﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Data.SqlClient;
using Festivali.Models;

namespace Festivali
{
    public class FestivaliDb : IFestival
    {
        private SqlConnection _connection = DbConnection.Connection;

        public List<int> dajSveGodine()
        {
            List<int> godine = new List<int>();

            _connection.Open();

            String query = @"select distinct(godina)
                             from lineup_festivala;";

            SqlCommand command = new SqlCommand(query, _connection);
            
            SqlDataReader reader = command.ExecuteReader();

            while (reader.Read())
            {
                godine.Add(int.Parse(reader["godina"].ToString()));
            }

            _connection.Close();

            return godine;
        }

        public List<Festival> dajFesivalePoGodini(int godina)
        {
            List<Festival> festivali = new List<Festival>();

            _connection.Open();

            String query = @"select * from festivali
                            where idFestivala in (
                                select idFestivala 
                                from lineup_festivala
                                where godina = @godina);";

            SqlCommand command = new SqlCommand(query, _connection);
            command.Parameters.AddWithValue("@godina", godina);

            SqlDataReader reader = command.ExecuteReader();

            while (reader.Read())
            {
                festivali.Add(new Festival(
                                            int.Parse(reader["idFestivala"].ToString()),
                                            reader["naziv"].ToString()
                                            ));
            }


            _connection.Close();
            return festivali;

        }

        public List<int> dajDaneFestivala(int godina, int idFestivala)
        {
            List<int> dani = new List<int>();

            _connection.Open();

            String query = @"select distinct(dan)
                             from lineup_festivala
                             where godina = @godina and idFestivala = @idFestivala;";

            SqlCommand command = new SqlCommand(query, _connection);
            command.Parameters.AddWithValue("@godina", godina);
            command.Parameters.AddWithValue("@idFestivala", idFestivala);

            SqlDataReader reader = command.ExecuteReader();

            while (reader.Read())
            {
                
                dani.Add(int.Parse(reader["dan"].ToString()));
            }


            _connection.Close();
            return dani;

        }

        public List<Posetilac> dajPosetioce(int godina, int idFestivala, int dan)
        {
            List<Posetilac> posetioci = new List<Posetilac>();

            _connection.Open();

            String query = @"select p.* 
                            from karte k join posetioci p
                            on k.idPosetioca = p.idPosetioca
                            where k.godina = @godina and k.idFestivala = @idFestivala and k.dan = @dan";

            SqlCommand command = new SqlCommand(query, _connection);
            command.Parameters.AddWithValue("@godina", godina);
            command.Parameters.AddWithValue("@idFestivala", idFestivala);
            command.Parameters.AddWithValue("@dan", dan);

            SqlDataReader reader = command.ExecuteReader();

            while (reader.Read())
            {
                posetioci.Add(new Posetilac(
                                            int.Parse(reader["idPosetioca"].ToString()),
                                            reader["ime"].ToString()
                                            ));
            }


            _connection.Close();
            return posetioci;
        }

        public List<Poseta> dajPosete(int idPosetioca)
        {
            List<Poseta> posete = new List<Poseta>();

            _connection.Open();

            String query = @"select f.naziv, k.godina, k.cena, k.dan 
                            from karte k join festivali f
                            on k.idFestivala = f.idFestivala
                            where k.idPosetioca = @idPosetioca";

            SqlCommand command = new SqlCommand(query, _connection);
            command.Parameters.AddWithValue("@idPosetioca", idPosetioca);

            SqlDataReader reader = command.ExecuteReader();

            while (reader.Read())
            {
                posete.Add(new Poseta(reader["naziv"].ToString(),
                                      int.Parse(reader["godina"].ToString()),
                                      int.Parse(reader["cena"].ToString()),
                                      int.Parse(reader["dan"].ToString())
                                            ));
            }


            _connection.Close();
            return posete;
        }
    }
}
