﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using Festivali.Models;
using System.Diagnostics;

namespace Festivali
{
    public partial class Form1 : Form
    {
        private IFestival db;
        public Form1()
        {
            InitializeComponent();
            
            radioButton1.Checked = true;
            ucitajBazu();
            button2.Enabled = false;
            
        }

        private void ucitajBazu()
        {
            string baza = "";
            if (radioButton1.Checked)
                baza = "sql";
            if (radioButton2.Checked)
                baza = "nosql";

            db = FestivalFactory.Festival(baza);
            init();
        }

        private void init()
        {
            comboBox1.Items.Clear();
            List<int> godine = db.dajSveGodine();

            foreach (int i in godine)
            {
                comboBox1.Items.Add(i);
            }

            comboBox1.SelectedIndex = 0;
            loadFestivale();

        }

        private void loadFestivale()
        {
            comboBox2.Items.Clear();
            int godina = (int)comboBox1.SelectedItem;

            List<Festival> festivali = db.dajFesivalePoGodini(godina);

            foreach (Festival festival in festivali)
            {
                comboBox2.Items.Add(festival);
            }

            comboBox2.SelectedIndex = 0;
            Debug.WriteLine(((Festival)comboBox2.SelectedItem).id);
            loadDane();

        }

        private void loadDane()
        {
            comboBox3.Items.Clear();
            int godina = (int)comboBox1.SelectedItem;
            Festival festival = (Festival)comboBox2.SelectedItem;
            Debug.WriteLine(((Festival)comboBox2.SelectedItem).id);

            List<int> dani = db.dajDaneFestivala(godina, festival.id);

            foreach (int i in dani)
            {
                comboBox3.Items.Add(i);
            }

            comboBox3.SelectedIndex = 0;

            ucitajImena();

        }

        private void ucitajImena()
        {
            dataGridView1.Rows.Clear();
            int godina = (int)comboBox1.SelectedItem;
            Festival festival = (Festival)comboBox2.SelectedItem;
            int dan = (int)comboBox3.SelectedItem;

            List<Posetilac> posetioci = db.dajPosetioce(godina, festival.id, dan);

            foreach (Posetilac posetilac in posetioci)
            {
                DataGridViewRow row = (DataGridViewRow)dataGridView1.Rows[0].Clone();
                row.Tag = posetilac;
                row.Cells[0].Value = posetilac.ime;

                dataGridView1.Rows.Add(row);
            }
        }


        private void comboBox1_SelectedIndexChanged(object sender, EventArgs e)
        {
            loadFestivale();

        }

        private void radioButton1_CheckedChanged(object sender, EventArgs e)
        {
            ucitajBazu();
        }

        private void radioButton2_CheckedChanged(object sender, EventArgs e)
        {
            ucitajBazu();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            dataGridView2.Rows.Clear();
            Posetilac posetilac = dataGridView1.SelectedRows[0].Tag as Posetilac;
            List<Poseta> posete = db.dajPosete(posetilac.id);

            foreach (Poseta poseta in posete)
            {
                DataGridViewRow row = (DataGridViewRow)dataGridView2.Rows[0].Clone();
                row.Tag = poseta;
                row.Cells[0].Value = poseta.nazivFestivala;
                row.Cells[1].Value = poseta.godina;
                row.Cells[2].Value = poseta.cena;
                row.Cells[3].Value = poseta.dan;

                dataGridView2.Rows.Add(row);
            }
        }
    }
}
