#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include <unistd.h>
#include <sys/wait.h>
#include <signal.h>

typedef struct
{
    long tip;
    int pid;
    int mec;
} Prijava;

typedef struct
{
    long tip;
    int pid;
    int poz;

} Igrac;

pid_t sudije[7];

void handler()
{
    for (int i = 0; i < 7; i++)
    {
        waitpid(sudije[i], NULL, 0);
        printf("Gotov je mec: %d\n", i);
    }
}

int main(void)
{
    signal(SIGINT, handler);
    int i, j;

    int id_sudija[7], id_sud;
    key_t key_sudija[7];

    key_t key_turnir = ftok("./server.c", 8);
    int id_turnin = msgget(key_turnir, IPC_CREAT | 0666);

    for (i = 1; i <= 7; i++)
    {
        key_sudija[i - 1] = ftok("./server.c", i);
        id_sudija[i - 1] = msgget(key_sudija[i - 1], IPC_CREAT | 0666);
    }

    Prijava prijave[8];

    Prijava prijava;

    int mec = 1;

    for (i = 0; i < 8; i++)
    {
        msgrcv(id_turnin, &prijava, sizeof(prijava), 1, 0);
        prijave[i] = prijava;
        prijave[i].mec = mec;
        if (i % 2 != 0)
            mec++;
    }

    for (i = 0; i < 8; i++)
    {
        prijava.tip = prijave[i].pid;
        prijava.mec = prijave[i].mec;

        msgsnd(id_turnin, &prijava, sizeof(prijava), 0);
    }

    pid_t sudija;

    for (i = 1; i <= 7; i++)
    {

        sudija = fork();
        if (sudija == -1)
        {
            printf("Fork greska.\n");
            exit(1);
        }
        else if (sudija == 0)
        {
            signal(SIGINT, SIG_IGN);
            sudija = getpid();

            id_sud = id_sudija[i - 1];

            Prijava p1, p2;

            msgrcv(id_sud, &p1, sizeof(p1), i, 0);
            msgrcv(id_sud, &p2, sizeof(p2), i, 0);

            Igrac igrac1, igrac2, temp;

            igrac1.tip = p1.pid;
            igrac1.poz = 1;

            igrac2.tip = p2.pid;
            igrac2.poz = 2;

            msgsnd(id_sud, &igrac1, sizeof(igrac1), 0);
            msgsnd(id_sud, &igrac2, sizeof(igrac2), 0);

            int rez1, rez2;

            for (j = 0; j < 3; j++)
            {
                msgrcv(id_sud, &igrac1, sizeof(igrac1), i, 0);
                msgrcv(id_sud, &igrac2, sizeof(igrac2), i, 0);

                if (igrac1.pid != p1.pid)
                {
                    temp.tip = igrac1.tip;
                    temp.pid = igrac1.pid;
                    temp.poz = igrac1.poz;
                    igrac1.tip = igrac2.tip;
                    igrac1.pid = igrac2.pid;
                    igrac1.poz = igrac2.poz;
                    igrac2.tip = temp.tip;
                    igrac2.pid = temp.pid;
                    igrac2.poz = temp.poz;
                }

                if (((igrac1.poz == igrac2.poz) && (j % 2)))
                {
                    igrac1.tip = igrac1.pid;
                    igrac1.pid = 1;

                    igrac2.tip = igrac2.pid;
                    igrac2.pid = 0;
                }
                else if (igrac1.poz == igrac2.poz)
                {
                    igrac1.tip = igrac1.pid;
                    igrac1.pid = 0;

                    igrac2.tip = igrac2.pid;
                    igrac2.pid = 1;
                }
                else if (j % 2)
                {
                    rez2++;
                    igrac1.tip = igrac1.pid;
                    igrac1.pid = 0;

                    igrac2.tip = igrac2.pid;
                    igrac2.pid = 1;
                }
                else
                {
                    rez1++;
                    igrac1.tip = igrac1.pid;
                    igrac1.pid = 1;

                    igrac2.tip = igrac2.pid;
                    igrac2.pid = 0;
                }

                msgsnd(id_sud, &igrac1, sizeof(igrac1), 0);
                msgsnd(id_sud, &igrac2, sizeof(igrac2), 0);
                if ((rez1 == 2 && rez2 == 0) || (rez1 == 0 && rez2 == 2))
                    exit(0);
            }
            exit(0);
        }
        else
        {
            sudije[i - 1] = sudija;
        }
    }

    sleep(1000);

    return 0;
}