﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using DEVSsharp;
using RSIspit2018Jun.vectors;

namespace RSIspit2018Jun.models
{
    public class PositionVelocity
    {
        public Vector3D Position { get; set; }
        public Vector3D Velocity { get; set; }
    }

    public class Lopta : Atomic
    {
        public double rL;
        private double eL;

        private Vector3D s;
        private Vector3D v;
        private Vector3D g;

        private List<PortValue> buffer;

        public InputPort inNewPosition;
        public InputPort inNewVelocity;

        public OutputPort outPosVel;

        public Lopta(string name, TimeUnit tu) : base(name, tu)
        {
            inNewPosition = AddIP("inNewPosition");
            inNewVelocity = AddIP("inNewVelocity");
            outPosVel = AddOP("outPosVel");
        }

        public override void init()
        {
            rL = 1.0;
            eL = 0.5;

            s = new Vector3D(2, 0, 2);
            v = new Vector3D(2, 0, 30);
            g = new Vector3D(0, 0, -9.81);

            buffer = new List<PortValue>
            {
                new PortValue(outPosVel, new PositionVelocity { Position = s, Velocity = v })
            };

        }

        public override double tau()
        {
            if (buffer.Count > 0)
                return 0.0;
            
            return GetTime();
        }

        public override bool delta_x(PortValue x)
        {
            if (x.port == inNewPosition)
            {
                CalculateNewPosition();
                CalculateNewVelocity();

                buffer.Add(new PortValue(outPosVel, new PositionVelocity { Position = s, Velocity = v }));

                s = (Vector3D)x.value;
                v = new Vector3D();

                return true;
            } 
            else if (x.port == inNewVelocity)
            {
                CalculateNewPosition();
                CalculateNewVelocity();

                buffer.Add(new PortValue(outPosVel, new PositionVelocity { Position = s, Velocity = v }));

                v = (Vector3D)x.value;

                return true;
            }

            return false;
        }

        public override void delta_y(ref PortValue y)
        {
            if (buffer.Count > 0)
            {
                y = buffer[0];
                buffer.RemoveAt(0);
                return;
            }

            CalculateNewPosition();
            CalculateNewVelocity();

            buffer.Add(new PortValue(outPosVel, new PositionVelocity { Position = s, Velocity = v }));
        }

        private void CalculateNewPosition()
        {
            s = s + v * TimeElapsed + g * TimeElapsed * TimeElapsed * 0.5; 
        }

        private void CalculateNewVelocity()
        {
            v = v + g * TimeElapsed;
        }

        private double GetTime()
        {
            double t0, t;
            double f, fPrim;

            t0 = eL / v.Intensity();
            while (Math.Abs(GetFunction(t0)) > 1.0E-6)
            {
                f = GetFunction(t0);
                fPrim = GetFunctionPrim(t0);

                t = t0 - f / fPrim;
                t0 = t;
            }

            return t0;
        }

        private double GetFunction(double t)
        {
            return (0.25 * g.Z * g.Z) * t * t * t * t + (v.Z * g.Z) * t * t * t + (v.X * v.X + v.Y * v.Y + v.Z * v.Z) * t * t - eL * eL;
        }

        private double GetFunctionPrim(double t)
        {
            return (g.Z * g.Z) * t * t * t + (3 * v.Z * g.Z) * t * t + 2 * (v.X * v.X + v.Y * v.Y + v.Z * v.Z) * t;
        }
    }
}
