﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using DEVSsharp;
using RSIspit2018Jun.vectors;

namespace RSIspit2018Jun.models
{
    public class Igra : Coupled
    {
        public InputPort inPositionIgra;

        public Igra(string name) : base(name)
        {
            inPositionIgra = AddIP("inPositionIgra");

            Lopta lopta = new Lopta("Lopta", TimeUnit.Sec);
            Povrsina pod = new Povrsina(double.MaxValue, double.MaxValue, new Vector3D(0, 0, 0), new Vector3D(0, 0, 1), "Pod", TimeUnit.Sec);
            Povrsina tabla = new Povrsina(25, 25, new Vector3D(0, 5, 5), new Vector3D(1, 0, 0), "Tabla", TimeUnit.Sec);            

            List<Povrsina> povrsine = new List<Povrsina>
            {
                pod,
                tabla
            };

            Printer printer = new Printer(povrsine.Count, "Printer", TimeUnit.Sec);
            Kontrolor kontrolor = new Kontrolor(lopta, povrsine, "Kontrolor", TimeUnit.Sec);

            AddModel(lopta);
            AddModel(printer);
            AddModel(pod);
            AddModel(tabla);
            AddModel(kontrolor);

            AddCP(inPositionIgra, lopta.inNewPosition);

            AddCP(lopta.outPosVel, printer.inPosVelPrinter);
            AddCP(lopta.outPosVel, kontrolor.inPosVelKontrolor);

            for (int i = 0; i < povrsine.Count; i++)
            {
                AddCP(kontrolor.outUdaracKontrolori[i], povrsine[i].inUdaracPovrsina);
                AddCP(povrsine[i].outVelocityPovrsina, lopta.inNewVelocity);
                AddCP(povrsine[i].outZvukPovrsina, printer.inZvukPrinteri[i]);
            }

            PrintCouplings();
        }
    }
}
