﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using DEVSsharp;
using RSIspit2018Jun.vectors;

namespace RSIspit2018Jun.models
{
    public class Kontrolor : Atomic
    {
        private bool flag = false;
        private List<PortValue> buffer;

        private Lopta lopta;
        private List<Povrsina> povrsine;

        public InputPort inPosVelKontrolor;
        public List<OutputPort> outUdaracKontrolori;

        public Kontrolor(Lopta lopta, List<Povrsina> povrsine, string name, TimeUnit tu) : base(name, tu)
        {
            this.lopta = lopta;
            this.povrsine = povrsine;

            inPosVelKontrolor = AddIP("inPosVelKontrolor");

            outUdaracKontrolori = new List<OutputPort>();
            for (int i = 0; i < povrsine.Count; i++)
                outUdaracKontrolori.Add(AddOP("outUdaracKontrolor" + i));
          
        }

        public override bool delta_x(PortValue x)
        {
            if (x.port == inPosVelKontrolor)
            {
                PositionVelocity sv = (PositionVelocity)x.value;              

                for (int i = 0; i < povrsine.Count; i++)
                {
                    if (povrsine[i].n == new Vector3D(0, 0, 1))
                    {
                        if (sv.Position.Z - lopta.rL <= povrsine[i].p.Z && sv.Position.Z + lopta.rL > povrsine[i].p.Z &&
                            sv.Position.X >= povrsine[i].p.X - povrsine[i].a / 2 && sv.Position.X <= povrsine[i].p.X + povrsine[i].a / 2 &&
                            sv.Position.Y >= povrsine[i].p.Y - povrsine[i].b / 2 && sv.Position.Y <= povrsine[i].p.Y + povrsine[i].b / 2)
                        {
                            buffer.Add(new PortValue(outUdaracKontrolori[i], sv.Velocity));
                            return true;
                        }                         
                    }
                    else if (povrsine[i].n == new Vector3D(1, 0, 0))
                    {
                        if (sv.Position.X - lopta.rL <= povrsine[i].p.X && sv.Position.X + lopta.rL > povrsine[i].p.X &&
                            sv.Position.Y >= povrsine[i].p.Y - povrsine[i].a / 2 && sv.Position.Y <= povrsine[i].p.Y + povrsine[i].a / 2 &&
                            sv.Position.Z >= povrsine[i].p.Z - povrsine[i].b / 2 && sv.Position.Z <= povrsine[i].p.Z + povrsine[i].b / 2)
                        {
                            buffer.Add(new PortValue(outUdaracKontrolori[i], sv.Velocity));
                            return true;
                        }
                    }
                }                    
            }

            return false;
        }

        public override void delta_y(ref PortValue y)
        {
            if (buffer.Count > 0)
            {
                y = buffer[0];
                buffer.RemoveAt(0);
                return;
            }
        }

        public override void init()
        {
            buffer = new List<PortValue>();
        }

        public override double tau()
        {
            if (buffer.Count > 0)
                return 0;

            return double.MaxValue;
        } 
    }
}
