﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using DEVSsharp;
using RSIspit2018Jun.vectors;

namespace RSIspit2018Jun.models
{
    public class Povrsina : Atomic 
    {
        public double a;
        public double b;
        private double kZ;
        private double eZ;
        private double alfa;

        public Vector3D p;
        public Vector3D n;

        private bool imaZvuk = false;
        private double zvuk = -1;
        private List<PortValue> buffer;

        public InputPort inUdaracPovrsina;
        public OutputPort outVelocityPovrsina;
        public OutputPort outZvukPovrsina;

        public Povrsina(double a, double b, Vector3D p, Vector3D n, string name, TimeUnit tu) : base(name, tu)
        {
            this.a = a;
            this.b = b;
            this.p = p;
            this.n = n;

            inUdaracPovrsina = AddIP("inUdaracPovrsina");
            outVelocityPovrsina = AddOP("outVelocityPovrsina");
            outZvukPovrsina = AddOP("outZvukPovrsina");
        }

        public override bool delta_x(PortValue x)
        {
            if (x.port == inUdaracPovrsina)
            {
                Vector3D v = (Vector3D)x.value;

                //Vector3D osaPotacije = v.CrossProduct(n);
                //double ugao = v.AngleBetween(n);

                //Vector3D newV = v.FreeRotate(osaPotacije, 2 * ugao);

                if (n == new Vector3D(0, 0, 1))
                {
                    Vector3D newV = new Vector3D(v.X, v.Y, -v.Z) * 0.9;
                    buffer.Add(new PortValue(outVelocityPovrsina, newV));
                }
                else if (n == new Vector3D(1, 0, 0))
                {
                    Vector3D newV = new Vector3D(-v.X, v.Y, v.Z) * 0.9;
                    buffer.Add(new PortValue(outVelocityPovrsina, newV));
                }

                zvuk = Math.Abs(v.DotProduct(n)) * kZ;
                imaZvuk = true;

                buffer.Add(new PortValue(outZvukPovrsina, zvuk));

                return true;
            }

            return false;
        }

        public override void delta_y(ref PortValue y)
        {
            if (buffer.Count > 0)
            {
                y = buffer[0];
                buffer.RemoveAt(0);
                return;
            }

            if (imaZvuk)
            {
                zvuk = zvuk * Math.Exp(-alfa * TimeElapsed);
                buffer.Add(new PortValue(outZvukPovrsina, zvuk));

                if (zvuk <= eZ)
                {
                    imaZvuk = false;
                    zvuk = 0;
                }
            }
        }

        public override void init()
        {
            kZ = 1;
            eZ = 1.5;
            alfa = 0.1;

            buffer = new List<PortValue>();
        }

        public override double tau()
        {
            if (buffer.Count > 0)
                return 0;

            if (!imaZvuk)
                return double.MaxValue;

            return -1 / alfa * Math.Log(1 - eZ / zvuk);
        }

        public override string Get_s()
        {
            return "{ imaZvuk: " + imaZvuk + " zvuk: " + zvuk + "}";
        }
    }
}
