﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using DEVSsharp;
using System.IO;
using RSIspit2018Jun.vectors;

namespace RSIspit2018Jun.models
{
    public class Printer : Atomic
    {
        private StreamWriter sw;

        public InputPort inPosVelPrinter;
        public List<InputPort> inZvukPrinteri;

        Vector3D pozicija;
        List<double> zvukovi;

        public Printer(int brPovrsi, string name, TimeUnit tu) : base(name, tu)
        {
            inPosVelPrinter = AddIP("inPosVelPrinter");
            inZvukPrinteri = new List<InputPort>();
            for (int i = 0; i < brPovrsi; i++)
                inZvukPrinteri.Add(AddIP("inZvukPrinter" + i));

            pozicija = new Vector3D(0, 0, 0);
            zvukovi = new List<double>();
            for (int i = 0; i < brPovrsi; i++)
                zvukovi.Add(0);
        }

        public override bool delta_x(PortValue x)
        {
            if (x.port == inPosVelPrinter)
            {
                PositionVelocity sv = (PositionVelocity)x.value;
                pozicija = sv.Position;

                string str = TimeCurrent + "," + pozicija.X + "," + pozicija.Y + "," + pozicija.Z;
                for (int i = 0; i < zvukovi.Count; i++)
                    str += "," + zvukovi[i];

                sw.WriteLine(str);                
                sw.Flush();
            }

            for (int j = 0; j < zvukovi.Count; j++)
            {
                if (x.port == inZvukPrinteri[j])
                {
                    zvukovi[j] = (double)x.value;

                    string str = TimeCurrent + "," + pozicija.X + "," + pozicija.Y + "," + pozicija.Z;
                    for (int i = 0; i < zvukovi.Count; i++)
                        str += "," + zvukovi[i];

                    sw.WriteLine(str);
                    sw.Flush();

                    break;
                }
            }

            return false;
        }

        public override void delta_y(ref PortValue y)
        {
            throw new NotImplementedException();
        }

        public override void init()
        {
            sw = new StreamWriter("Izlaz.csv");
            sw.WriteLine("Time,X,Y,Z,ZvukPod,ZvukTabla");
            sw.Flush();
        }

        public override double tau()
        {
            return double.MaxValue;
        }
    }
}
