﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace RSIspit2018Jun.vectors
{
    public class Vector3D
    {
        private double x;
        private double y;
        private double z;

        public double X
        {
            get { return x; }
            set { x = value; }
        }

        public double Y
        {
            get { return y; }
            set { y = value; }
        }

        public double Z
        {
            get { return z; }
            set { z = value; }
        }

        public Vector3D()
        {
            Init(0, 0, 0);
        }

        public Vector3D(double x, double y, double z)
        {
            Init(x, y, z);
        }

        public Vector3D(Vector3D v)
        {
            Init(v.x, v.y, v.z);
        }

        private void Init(double x, double y, double z)
        {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public double Intensity()
        {
            return Math.Sqrt(x * x + y * y + z * z);
        }

        public double DotProduct(Vector3D v)
        {
            return x * v.x + y * v.y + z * v.z;
        }

        public Vector3D CrossProduct(Vector3D v)
        {
            Vector3D vCross = new Vector3D();
            vCross.x = y * v.z - z * v.y;
            vCross.y = -x * v.z + z * v.x;
            vCross.z = x * v.y - y * v.x;
            return vCross;
        }

        public double AngleBetween(Vector3D v)
        {
            Vector3D cross = CrossProduct(v);
            double sin = cross.Intensity() / (Intensity() * v.Intensity());
            double cos = DotProduct(v) / (Intensity() * v.Intensity());

            return Math.Atan2(sin, cos);
        }

        public Vector3D FreeRotate(Vector3D v, double alfa)
        {
            v = v * (1 / v.Intensity());
            Vector3D result = new Vector3D();

            result.x = 
                (Math.Cos(alfa) + v.x * v.x * (1 - Math.Cos(alfa))) * x +
                (v.x * v.y * (1 - Math.Cos(alfa)) - v.z * Math.Sin(alfa)) * y +
                (v.x * v.z * (1 - Math.Cos(alfa)) + v.y * Math.Sin(alfa)) * z;

            result.y =
                (v.y * v.x * (1 - Math.Cos(alfa)) + v.z * Math.Sin(alfa)) * x +
                (Math.Cos(alfa) + v.y * v.y * (1 - Math.Cos(alfa))) * y +
                (v.y * v.z * (1 - Math.Cos(alfa)) - v.x * Math.Sin(alfa)) * z;

            result.z =
                (v.z * v.x * (1 - Math.Cos(alfa)) - v.y * Math.Sin(alfa)) * x +
                (v.z * v.y * (1 - Math.Cos(alfa)) + v.x * Math.Sin(alfa)) * y +
                (Math.Cos(alfa) + v.z * v.z * (1 - Math.Cos(alfa))) * z;

            return result;
        }

        public static Vector3D operator +(Vector3D a, Vector3D b)
        {
            Vector3D v = new Vector3D(a);
            v.x += b.x;
            v.y += b.y;
            v.z += b.z;
            return v;
        }

        public static Vector3D operator -(Vector3D a, Vector3D b)
        {
            Vector3D v = new Vector3D(a);
            v.x -= b.x;
            v.y -= b.y;
            v.z -= b.z;
            return v;
        }

        public static Vector3D operator *(Vector3D a, double k)
        {
            Vector3D v = new Vector3D(a);
            v.x *= k;
            v.y *= k;
            v.z *= k;
            return v;
        }

        public static bool operator ==(Vector3D a, Vector3D b)
        {
            if (Math.Abs(a.x - b.x) < 1.0E-6 && Math.Abs(a.y - b.y) < 1.0E-6 && Math.Abs(a.z - b.z) < 1.0E-6)
                return true;

            return false;
        }

        public static bool operator !=(Vector3D a, Vector3D b)
        {
            if (Math.Abs(a.x - b.x) < 1.0E-6 && Math.Abs(a.y - b.y) < 1.0E-6 && Math.Abs(a.z - b.z) < 1.0E-6)
                return false;

            return true;
        }

        public override string ToString()
        {
            return "Vector3D(" + x +", " + y +", " + z + ")";
        }
    }
}
