%{
/* kompajliranje 
yacc -d fajl.y    
yacc -d -v fajl.y dobijanje opisa automata
yacc -d -v -t fajl.y debug 

Primer:
lex prviPrimer.l
yacc -d -t -v prviPrimer.y
gcc -o izv lex.yy.c y.tab.c -lfl
./izv
*/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
int yyline=1;
int yylex();
int yyerror(char* s);
int yydebug=1; // samo u debug-u

%}
%token INT ID NUM

%%
program : varSekcija | varSekcija program;
varSekcija : deklaracija | definicija | deklaracija '\n' | definicija '\n';
deklaracija: INT ' ' ID ';' ;
definicija: INT ' ' ID '=' NUM ';' |
            error '\n' {yyerrok;}

%%
int yyerror(char *s)
{
    printf("\n greska %s se dogodila u redu %d \n",s,yyline);
}

int main()
{
    extern FILE *yyin;
    if (yyparse()==0) 
        printf("Parsiranje uspesno zavrseno \n");
    else 
        printf("Parsiranje NIJE uspesno zavrseno");
    return 0;
}
