%{
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

int yyline=1;
int yylex();
int yyerror(char* s);
int yydebug=1;
%}

%start list
%union 
{
    int ival;
    char name[32];
}

%token <name> BROJ
%type <ival> expr stat

%left '+' '-'
%left '*' '/'

%%

list : stat | list stat;
stat : expr '.'
    {
        printf("Rezultat je %d\n",$1);
    };
expr :'(' expr ')' { $$ = $2;}
    | expr '+' expr {$$ = $1 + $3;}
    | expr '-' expr {$$ = $1 - $3;}
    | expr '*' expr {$$ = $1 * $3;}
    | expr '/' expr {$$ = $1 / $3;}
    | '-' expr %prec '*' {$$ = -$2;}
    | BROJ {$$ = atoi($1);};
%%

int yyerror(char *s)
{
    printf("\n greska %s se dogodila u redu %d \n",s, yyline);
}

int main()
{
    extern FILE *yyin;
    if (yyparse()==0) 
        printf("Parsiranje uspesno zavrseno \n");
    else 
        printf("Parsiranje NIJE uspesno zavrseno");
    return 0;
}