create database baza_filmova
use baza_filmova

create table filmovi
(
	id int identity primary key, 
	naziv varchar(100), 
	godina int, 
	trajanje int, 
	zanr varchar(100), 
	ocena decimal(4,1), 
	opis varchar(100)
)

create table osobe
(
	id int identity primary key,
	ime varchar(100), 
	datum_rodjenja date, 
	biografija varchar(100),
	status varchar(100),
	trenutna_zarada decimal(10,2)
)

create table angazovanje
(
	id int identity primary key,
	id_osobe int references osobe(id), 
	id_filma int references filmovi(id), 
	svojstvo varchar(20),
	status varchar(20)
)

create table zarada
(
	id int identity primary key,
	dan int,
	id_filma int references filmovi(id),
	iznos decimal(10,2)
)
go

--Osobe
insert into osobe(ime,datum_rodjenja,biografija,status,trenutna_zarada)
values('Pera','1990-01-01','biografija 1','slobodan',0)
insert into osobe(ime,datum_rodjenja,biografija,status,trenutna_zarada)
values('Mika','1991-01-01','biografija 2','slobodan',0)
insert into osobe(ime,datum_rodjenja,biografija,status,trenutna_zarada)
values('Zika','1992-01-01','biografija 3','slobodan',0)
insert into osobe(ime,datum_rodjenja,biografija,status,trenutna_zarada)
values('Laza','1993-01-01','biografija 4','slobodan',0)
insert into osobe(ime,datum_rodjenja,biografija,status,trenutna_zarada)
values('Ana','1994-01-01','biografija 5','slobodan',0)
insert into osobe(ime,datum_rodjenja,biografija,status,trenutna_zarada)
values('Lana','1995-01-01','biografija 6','slobodan',0)

--Filmovi
insert into filmovi(naziv,godina,trajanje,zanr,ocena,opis)
values('Film 1',2010,90,'komedija',3,'opis 1')
insert into filmovi(naziv,godina,trajanje,zanr,ocena,opis)
values('Film 2',2011,111,'triler',3,'opis 2')
insert into filmovi(naziv,godina,trajanje,zanr,ocena,opis)
values('Film 3',2010,130,'horor',3,'opis 3')
insert into filmovi(naziv,godina,trajanje,zanr,ocena,opis)
values('Film 4',2019,98,'komedija',3,'opis 4')
insert into filmovi(naziv,godina,trajanje,zanr,ocena,opis)
values('Film 5',2018,104,'misterija',3,'opis 5')
insert into filmovi(naziv,godina,trajanje,zanr,ocena,opis)
values('Film 6',2020,150,'komedija',3,'opis 6')