-- SET TRANSACTION ISOLATION LEVEL { read uncommitted | read committed | repeatable read | serializable | snapshot }
-- ALTER DATABASE ime_baze SET ALLOW_SNAPSHOT_ISOLATION ON
-- SET DEADLOCK_PRIORITY { LOW | NORMAL | HIGH | <numeric-priority> }

use baza_filmova

create procedure sp_unesi_zaradu_filma
(
	@dan int,
	@idFilma int,
	@iznos decimal(10,2)
)
as
begin
	insert into zarada (dan, id_filma, iznos)
	values (@dan, @idFilma, @iznos)
end
go

create procedure sp_angazuj
(
	@idFilma int,
	@ime varchar(100),
	@svojstvo varchar(20)
)
as
begin
	declare @idOsobe int
	declare @brojAngazovanja int

	select top 1 @idOsobe=id
	from osobe
	where ime like @ime
	order by trenutna_zarada
		
	select @brojAngazovanja=count(*)
	from angazovanje
	where id_filma=@idFilma and id_osobe=@idOsobe and svojstvo like @svojstvo

	waitfor delay '00:00:10'

	if @brojAngazovanja = 0
	begin
		insert into angazovanje (id_osobe, id_filma, svojstvo, status)
		values (@idOsobe, @idFilma, @svojstvo, 'aktivno')

		update osobe
		set status='angazovan'
		where id=@idOsobe
	end
end
go

create procedure sp_filmografija
(
	@idOsobe int
)
as
begin
	declare @idFilma int
	declare @id int

	declare kursorAngazovanje cursor for
	select id,id_filma from angazovanje
	where id_osobe=@idOsobe and status like 'zavrseno'

	open kursorAngazovanje

	fetch next from kursorAngazovanje
	into @id, @idFilma

	while @@FETCH_STATUS = 0
	begin
		
		select naziv
		from filmovi
		where id=@idFilma

		fetch next from kursorAngazovanje
		into @id, @idFilma
	end

	close kursorAngazovanje
	deallocate kursorAngazovanje
end
go

create procedure sp_vise_svojstava
(
	@idFilma int,
	@idOsobe int
)
as
begin
	declare @brojAngazovanja decimal(10,2)

	select @brojAngazovanja=count(*)
	from angazovanje
	where id_filma=@idFilma and id_osobe=@idOsobe

	if @brojAngazovanja > 1
	begin
		delete from angazovanje
		where id_filma=@idFilma and id_osobe=@idOsobe and svojstvo like 'glumac'
	end
end
go

create procedure sp_isplati_angazovanog
(
	@idAngazovanja int
)
as
begin
	declare @idFilma int
	declare @idOsobe int
	declare @ukupanIznos decimal(10,2)
	declare @brojAngazovanih int
	declare @prosecnaZarada decimal(10,2)
	declare @status varchar(100)

	select @idFilma=id_filma, @idOsobe=id_osobe, @status=status
	from angazovanje
	where id=@idAngazovanja

	select @ukupanIznos=sum(iznos)
	from zarada
	where id_filma=@idFilma

	select @brojAngazovanih=count(*)
	from angazovanje
	where id_filma=@idFilma

	if @brojAngazovanih > 0 and @status <> 'zavrseno'
	begin
		set @prosecnaZarada=@ukupanIznos/@brojAngazovanih
		if @status<>'zavrseno'
		begin
			update osobe
			set trenutna_zarada = trenutna_zarada + @prosecnaZarada
			where id=@idOsobe

			update angazovanje
			set status='zavrseno'
			where id=@idAngazovanja
		end
	end
end
go

create procedure sp_izlistaj_zarade
(
	@dan int
)
as
begin
	select sum(iznos) as 'zarada'
	from zarada
end
go