let inpUser = document.getElementById('inp-user')
let inpPass = document.getElementById('inp-pass')
let errMsg = document.getElementById('error-msg')

let cntLogin = document.getElementById('login')
let cntPrikaz = document.getElementById('prikaz')

let rbNew = document.getElementById('rb-year-newer')
let rbOld = document.getElementById('rb-year-older')
let inpTitle = document.getElementById('inp-title')
let inpYear = document.getElementById('inp-year')
let selGenre = document.getElementById('sel-genre')
let selDirs = document.getElementById('sel-director')

let tableElem = document.getElementById('tbl-movies')

let cntList = document.getElementById('list-container')
let listElem = document.getElementById('list')
let listCount = document.getElementById('list-count')
let listRating = document.getElementById('list-rating')
let listEmpty = document.getElementById('list-empty')
let listButton = document.getElementById('list-button')

let btnLogout = document.getElementById('btn-logout')


let movies = []

listButton.onclick = () => {
    for (const movie of movies) {
        movie.inList = false
        updateList()
    }
}

let xhr = null // DEBUG
getData()

function login() 
{
    // Pocinje sa @, nakon toga idu bar 2 slova, nakon toga tacno cifre (min. len. 6)
    let regUser = /^@[A-Za-z]{2,}[0-9]{2}[A-Za-z]*$/
    
    // Sifra se sastoji samo od slova i jednog specijalnog karaktera.
    // Mora da sadrzi bar jedno veliko slovo, i da se zavrsava jednim od znakova - _ ! ? ~
    let regPass = /^[a-z]*[A-Z]+[A-Za-z]*[\-_!?~]$/


    if(regUser.test(inpUser.value) && regPass.test(inpPass.value)) {
        errMsg.innerText = ''
        cntLogin.hidden = true
        cntPrikaz.hidden = false
        btnLogout.hidden = false
    }
    else {
        errMsg.innerText = 'Nisu validni kredencijali'
    }
}

function logout() 
{
    cntLogin.hidden = false
    cntPrikaz.hidden = true
    btnLogout.hidden = true
}


function getData()
{
    // let xhr = new XMLHttpRequest()
    xhr = new XMLHttpRequest() // DEBUG
    
    xhr.onload = function() {
        if(this.status != 200) return

        let xmlMovies = xhr.responseXML.getElementsByTagName('Movie')

        // Save list of objects with cereal data
        for (let xmlMovie of xmlMovies) 
        {
            let obj = {
                title: xmlMovie.getElementsByTagName('Series_Title')[0].textContent,
                director: xmlMovie.getElementsByTagName('Director')[0].textContent,
                year: Number(xmlMovie.getElementsByTagName('Released_Year')[0].textContent),
                rating: Number(xmlMovie.getElementsByTagName('Meta_score')[0].textContent),
                genres: [],
                inList: false
            }
            let xmlGenres = xmlMovie.getElementsByTagName('Genre')
            for (const xmlGenre of xmlGenres) {
                obj.genres.push(xmlGenre.textContent)
            }
            movies.push(obj)
        }

        // Genres
        let xmlGenres = xhr.responseXML.getElementsByTagName('Genre')
        let genres = []
        for(let xmlGenre of xmlGenres) {
            let text = xmlGenre.textContent
            let index = genres.findIndex((val) => text == val)
            let exist = index != -1
            if(!exist) {
                selGenre.innerHTML += `
                    <option value="${text}">
                        ${text}
                    </option>
                `
                genres.push(text)
            }
        }

        // Directors
        let xmlDirectors = xhr.responseXML.getElementsByTagName('Director')
        let diroctors = []
        for(let xmlDir of xmlDirectors) {
            let text = xmlDir.textContent
            let index = diroctors.findIndex((val) => text == val)
            let exist = index != -1
            if(!exist) {
                selDirs.innerHTML += `
                    <option value="${text}">
                        ${text}
                    </option>
                `
                diroctors.push(text)
            }
        }

        updateTable()
        tempFn() // DEBUG
    }

    xhr.open('GET', 'imdb.xml', true)
    xhr.send()
}

function updateTable()
{
    tableElem.innerHTML = ''
    for(let movie of movies) 
    {
        if(!matchFilter(movie)) continue // Preskoči ovu iteraciju

        let row = document.createElement('tr')
        row.innerHTML = `
            <td>${movie.title}</td>
            <td>${movie.director}</td>
            <td>${movie.year}</td>
            <td>${movie.rating}</td>
            <td>${movie.genres.join(', ')}</td>
        `

        let btn = document.createElement('button')
        btn.innerText = 'Save'
        btn.onclick = function() {
            movie.inList = true
            updateList()
        }

        let btnCell = document.createElement('td')
        btnCell.appendChild(btn)
        row.appendChild(btnCell)
        
        tableElem.appendChild(row)
    }
}

function updateList()
{
    let total = 0
    let count = 0
    listElem.innerHTML = ''
    
    for(let movie of movies) 
    {
        if(!movie.inList) continue
        
        listElem.innerHTML += `
            <tr>
                <td>${movie.title}</td>
                <td>${movie.rating}</td>
            </tr>
        `
        total += movie.rating
        count++
    }
    
    let isEmpty = count == 0

    listCount.innerHTML = 'Count: ' + count
    listRating.innerHTML = 'Average Score: ' + (isEmpty ? 0 : (total/count))

    listEmpty.hidden = !isEmpty
    cntList.hidden = isEmpty
}

// Vraca true ako podaci zitarice odgovaraju trenutno postavljenim filterima
function matchFilter(movie) 
{
    let regTitle = new RegExp(inpTitle.value, 'i')
    let okTitle = regTitle.test(movie.title)
    
    let year = inpYear.value == '' ? null : Number(inpYear.value)
    let okYear = (year == null) ||
                 (rbNew.checked && movie.year >= year) ||
                 (rbOld.checked && movie.year <= year)
    
    let okGenre = (movie.genres.indexOf(selGenre.value) != -1) ||
                  (selGenre.value == 'all')
    
    let okDirector = (movie.director == selDirs.value) ||
                     (selDirs.value == 'all')

    return okTitle && okYear && okGenre && okDirector
}



// DEBUG

let directors = []
function tempFn() 
{
    let xmlDirs = xhr.responseXML.getElementsByTagName('Director')
    for(let xmlDir of xmlDirs) 
    {
        let i = directors.findIndex((val) => val.dir.textContent == xmlDir.textContent)
        if(i != -1) {
            directors[i].movies++
        }
        else {
            directors.push({dir: xmlDir, movies: 1})
        }
    }
    directors.sort((a,b) => a.movies - b.movies)
}