let codeInpElem = document.getElementById('inp-code')
let codeOkElem = document.getElementById('code-ok')

let yearSelElem = document.getElementById('sel-year')
let nameInpElem = document.getElementById('inp-name')
let rateInpElem = document.getElementById('inp-rating')
let tableElem = document.getElementById('tbl-games')

let detailsElem = document.getElementById('div-details')

let divGamesElem = document.getElementById('div-games')
let divCodeElem = document.getElementById('div-code')

codeInpElem.onkeyup = checkCode
nameInpElem.onkeyup = updateTable
rateInpElem.onkeyup = updateTable
yearSelElem.onchange = updateTable

let games = []

function checkCode() {
    let code = codeInpElem.value
    let reg = /^[0-9A-Z]{2}:[0-9A-Z]{2}@[a-z]{2,}$/ // F3:7A@pera

    codeOkElem.hidden = !reg.test(code)
}

function submitCode() {
    let code = codeInpElem.value
    if (code == 'AB:12@pera') {
        divCodeElem.hidden = true
        divGamesElem.hidden = false
    }
}

function loadData() {
    let xhr = new XMLHttpRequest()

    xhr.onload = function () {
        let xmlDoc = this.responseXML
        let xmlGames = xmlDoc.getElementsByTagName('game')
        for (const xmlGame of xmlGames) {
            let game = {
                name: xmlGame.getElementsByTagName('name')[0].textContent,
                plot: xmlGame.getElementsByTagName('plot')[0].textContent,
                url: xmlGame.getElementsByTagName('url')[0].textContent,
                year: Number(xmlGame.getElementsByTagName('year')[0].textContent),
                rating: Number(xmlGame.getElementsByTagName('rating')[0].textContent),
            }
            games.push(game)
        }

        let collection = xmlDoc.getElementsByTagName('year')
        let arrayTemp = Array.from(collection).map((val) => Number(val.textContent))
        let set = new Set(arrayTemp)
        let array = Array.from(set).sort().reverse()

        for (const year of array) {
            yearSelElem.innerHTML += `
                <option value="${year}">${year}</option>
            `
        }

        console.log(array)

        updateTable()
    }

    xhr.open('GET', './games.xml', true)
    xhr.send()
}

function updateTable() {
    tableElem.innerHTML = `
        <tr>
            <th>Name</th> <th>Year</th> <th>Rating</th> 
        </tr>
    `
    for (const game of games) {
        if (!matchFilter(game)) continue

        let row = document.createElement('tr')
        row.innerHTML = `
            <td>${game.name}</td>
            <td>${game.year}</td>
            <td>${game.rating}</td>
        `
        row.onclick = () => {
            showDetails(game)
        }
        tableElem.appendChild(row)
    }
}

function showDetails(game) {
    detailsElem.innerHTML = `
        <h3>${game.name}</h3>
        <p>${game.plot}</p>
        <a href="${game.url}" target="_blank"> View on IMDB </a>
    `
}

function matchFilter(game) {
    let year = yearSelElem.value
    let name = nameInpElem.value
    let rate = rateInpElem.value

    let okYear = year == 'any' || Number(year) == game.year
    let okName = game.name.toLowerCase().indexOf(name.toLowerCase()) != -1
    let okRate = rate == '' || game.rating >= Number(rate)

    return okYear && okName && okRate
}
