import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class GridGUI {
	public static void main(String[] args){
		ButtonFrame frame = new ButtonFrame();
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.setVisible(true);
	}
}

class ButtonFrame extends JFrame
{
	public ButtonFrame(){
		setTitle("Test s bojom pozadine");
		setSize(300,200);
		Container cp = getContentPane();
		ButtonPanel panel = new ButtonPanel();
		cp.add(panel);
	}
}

class ButtonPanel extends JPanel{
	public ButtonPanel() {
		JButton yellow = new JButton("Yellow");
		JButton blue = new JButton("Blue");
		JButton red = new JButton("Red");
		add(yellow);
		add(blue);
		add(red);
		ColorAction yellowAction = new ColorAction(Color.YELLOW);
		ColorAction blueAction = new ColorAction(Color.BLUE);
		ColorAction redAction = new ColorAction(Color.RED);
		yellow.addActionListener(yellowAction);
		blue.addActionListener(blueAction);
		red.addActionListener(redAction);
	}
	private class ColorAction implements ActionListener
	{
		// Privatna unutasnja klasa - ColorAction() konstruktor ne mora
		// dobiti referencu na ButtonPanel koja bi joj trebala da dohvati
		// ButtonPanel.setBackground(backgroundColor)
		private Color bgColor;
		public ColorAction(Color c)
		{
			bgColor = c;
		}
		public void actionPerformed(ActionEvent e)
		{
			// metoda JComponent klase
			setBackground(bgColor);
		}
	}

}