import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import javax.swing.*;
import java.util.*;
public class TestMouseListener {
	public static void main(String[] args) {
		MouseFrame mf = new MouseFrame();
		mf.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		mf.setVisible(true);
	}
}
class MouseFrame extends JFrame {
	public MouseFrame() {
		setTitle("MouseFrame");
		setSize(300,200);
		MousePanel mp = new MousePanel();
		Container contentPane = getContentPane();
		contentPane.add(mp);
	}
}
class MousePanel extends JPanel {
	private static final int DUZINA = 10;
	private ArrayList kvadrati; 
	private Rectangle2D trenutni; 
	public MousePanel() {
		kvadrati = new ArrayList();
		trenutni = null;
		addMouseListener(new MouseHandler());
		addMouseMotionListener(new MouseMotionHandler());
	}
	public void paintComponent(Graphics g) {
		super.paintComponent(g);
		Graphics2D g2 = (Graphics2D) g;
		for(int i=0; i<kvadrati.size(); ++i)
			g2.draw((Rectangle2D) kvadrati.get(i));
	}
	public void add(Point2D p) {
		double x = p.getX();
		double y = p.getY();
		trenutni = new Rectangle2D.Double(x-DUZINA/2, y-DUZINA/2,
				DUZINA, DUZINA);
		kvadrati.add(trenutni);
		repaint();
	}
	public Rectangle2D find(Point2D p) {
		for(int i=0; i<kvadrati.size(); ++i){
			Rectangle2D rec=(Rectangle2D) kvadrati.get(i);
			if(rec.contains(p)) return (Rectangle2D) kvadrati.get(i);
		}
		return null;
	}
	public void remove(Rectangle2D r) {
		if(r == null) return;
		if(r == trenutni) trenutni = null;
		kvadrati.remove(r);
		repaint();
	}
	private class MouseHandler extends MouseAdapter {
		public void mousePressed(MouseEvent e) {
			trenutni = find(e.getPoint());
			if(trenutni == null) 
				add(e.getPoint());
		}
		public void mouseClicked(MouseEvent e) {
			trenutni = find(e.getPoint());
			if(trenutni != null && e.getClickCount() >=2 )
				remove(trenutni); 
		}
	}

	private class MouseMotionHandler implements MouseMotionListener {
		public void mouseMoved(MouseEvent e) {
			if(find(e.getPoint()) == null)
				setCursor(Cursor.getDefaultCursor());
			else
				setCursor(Cursor.getPredefinedCursor(Cursor.CROSSHAIR_CURSOR));
		}
		public void mouseDragged(MouseEvent e) {
			if(trenutni != null)
			{
				int x = e.getX();
				int y = e.getY();
				trenutni.setFrame(x-DUZINA/2, y-DUZINA/2, DUZINA, DUZINA);
				repaint();
			}
		}
	}
}