import izuzeci.NedovoljnoNovca;
import karte.Karta;
import prevoz.PrevoznoSredstvo;
import putnici.Putnik;

public class Destinacija {
	
	
	private PrevoznoSredstvo[] prevoznaSredstva;
	
	private String doMesta;
	private String odMesta;
	private double razdaljina;
	public Destinacija(String doMesta, String odMesta, double razdaljina, int maxBrojPrevoznihSredstava) {
		super();
		this.doMesta = doMesta;
		this.odMesta = odMesta;
		this.razdaljina = razdaljina;
		this.prevoznaSredstva = new PrevoznoSredstvo[maxBrojPrevoznihSredstava];
	}
	
	public void dodajPrevoznoSredstvo(PrevoznoSredstvo prevoznoSredstvo)
	{
		int i=0;
		while(prevoznaSredstva[i]!=null && i<prevoznaSredstva.length)
		{
			i++;
		}
		
		if (i<prevoznaSredstva.length)
			prevoznaSredstva[i] = prevoznoSredstvo;
	}
	
	
	
	public boolean equals(String odMesta, String doMesta)
	{
		return this.odMesta.equals(odMesta) && this.doMesta.equals(doMesta);
	}
	
	public Karta kupiKartu(Putnik putnik) throws NedovoljnoNovca
	{
		
		PrevoznoSredstvo najbrzePrevoznoSredstvo = null;
		
		for (int i=0; i<prevoznaSredstva.length; i++)
		{
			if (prevoznaSredstva[i] == null)
				break;
			
			if ( najbrzePrevoznoSredstvo == null || prevoznaSredstva[i].vremePutovanja(razdaljina)< najbrzePrevoznoSredstvo.vremePutovanja(razdaljina))
			{
				najbrzePrevoznoSredstvo = prevoznaSredstva[i];
			}
			
		}
		
		Karta k = najbrzePrevoznoSredstvo.dajKartu(razdaljina, putnik);
		
		if (k != null)
		{
			najbrzePrevoznoSredstvo.cekirajKartu(k);
			return k;		
		}
		else
			throw new NedovoljnoNovca("Putnik nema dovoljno novca.");
	}
	
	
	

	
	
}
