import izuzeci.NedovoljnoNovca;
import izuzeci.NepostojecaDestinacija;
import karte.Karta;
import putnici.Putnik;

public class TuristickaAgencija {
	
	private Destinacija[] destinacije;
	private String naziv;
	
	public TuristickaAgencija(int maxDestinacija, String naziv)
	{
		this.destinacije = new Destinacija[maxDestinacija];
		this.naziv = naziv;
	}
	
	public void dodajDestinaciju(Destinacija destinacija)
	{
		int i=0;
		while(destinacije[i]!=null && i<destinacije.length)
		{
			i++;
		}
		
		if (i<destinacije.length)
			destinacije[i] = destinacija;
	}
	
	public Karta kupiKartu(String odMesta, String doMesta, Putnik putnik) throws NedovoljnoNovca, NepostojecaDestinacija
	{
		for (int i=0; i<destinacije.length; i++)
		{
			if (destinacije[i].equals(odMesta, doMesta))
			{
				Karta k = destinacije[i].kupiKartu(putnik);
				return k;
			}
		}
		throw new NepostojecaDestinacija("Ova destinacija ne postoji");
	}
	
	
	

}
