package prevoz;

import karte.EkonomskaKlasa;
import karte.Karta;
import putnici.Putnik;

public class Autobus extends PrevoznoSredstvo{
	
	static double cenaPoKilometru = 5;
	static double cenaPoKilogramuPrtljaga = 2;
	
	public Autobus(int brojSlobodnihMesta, double brzinaPrevoza)
	{
		super(brzinaPrevoza);
		
		this.karte = new Karta[brojSlobodnihMesta];
	}
	

	@Override
	public void cekirajKartu(Karta karta) {
		int i=0;
		while(karte[i]!=null && i<karte.length)
		{
			i++;
		}
		
		if (i<karte.length)
			karte[i] = karta;
		
	}

	@Override
	public Karta dajKartu(double razdaljina, Putnik putnik) {
		Karta karta = new EkonomskaKlasa(putnik, Autobus.cenaPoKilometru, Autobus.cenaPoKilogramuPrtljaga, razdaljina);
		if (karta.dajCenuKarte()> putnik.getBudzet())
		{
			return null;
		}
		else
		{
//			
			
			return karta;
		}
	}

	@Override
	public int brojSlobodnihMesta() {
		int i=0;
		while(karte[i]!=null && i<karte.length)
		{
			i++;
		}
		
		return karte.length-i;
	}
	
	

}
