package prevoz;

import karte.BiznisKlasa;
import karte.EkonomskaKlasa;
import karte.Karta;
import putnici.Putnik;

public class Avion extends PrevoznoSredstvo {

	private int brojSlobodnihMestaUEkonomskoj;
	private int brojSlobodnihMestaUBiznis;
	
	static double cenaPoKilometruEkonomska;
	static double cenaPoKilometruBiznis;
	static double cenaPrtaljagaPoKilogramu;
	
	public Avion(int brojMestaEkonomska, int brojMestaBiznis, double brzinaPrevoza)
	{
		super(brzinaPrevoza);
		this.brojSlobodnihMestaUEkonomskoj = brojMestaEkonomska;
		this.brojSlobodnihMestaUBiznis = brojMestaBiznis;
		
		this.karte= new Karta[brojSlobodnihMestaUBiznis+brojSlobodnihMestaUEkonomskoj];
		
	}
	
	
	@Override
	public void cekirajKartu(Karta karta) {
		int i=0;
		while(karte[i]!=null && i<karte.length)
		{
			i++;
		}
		
		if (i<karte.length)
			karte[i] = karta;
		
		if (karta instanceof BiznisKlasa)
			brojSlobodnihMestaUBiznis--;
		else
			brojSlobodnihMestaUEkonomskoj--;
		
		
	}

	@Override
	public Karta dajKartu(double razdaljina, Putnik putnik) {
		Karta k = new BiznisKlasa(putnik, cenaPoKilometruBiznis, cenaPrtaljagaPoKilogramu, razdaljina);
		if (putnik.getBudzet()< k.dajCenuKarte())
		{
			k = new EkonomskaKlasa(putnik, cenaPoKilometruEkonomska, cenaPrtaljagaPoKilogramu, razdaljina);
			if (putnik.getBudzet()<k.dajCenuKarte())
			{
				return null;
			}
			else
			{
				return k;
			}
		}
		else
			return k;
	}

	@Override
	public int brojSlobodnihMesta() {
		return brojSlobodnihMestaUBiznis+brojSlobodnihMestaUEkonomskoj;
	}

}
