package prevoz;

import karte.Karta;
import putnici.Putnik;

public abstract class PrevoznoSredstvo {
	
	private double brzinaPrevoza;
	Karta[] karte;
	
	public PrevoznoSredstvo(double brzinaPrevoza)
	{
		this.brzinaPrevoza = brzinaPrevoza;
	}
	
	public abstract void cekirajKartu(Karta karta);
	
	public abstract Karta dajKartu(double razdaljina, Putnik putnik);
	
	public double vremePutovanja(double razdaljinu)
	{
		return razdaljinu/brzinaPrevoza;
	}
	
	public abstract int brojSlobodnihMesta();
	
	
	public Karta[] getKarte()
	{
		return karte;
	}
	
		

}
