package pmf.imi.ebank;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

import static org.junit.jupiter.api.Assertions.*;
import static org.mockito.ArgumentMatchers.*;
import static org.mockito.Mockito.when;

class KarticaTest {

    @InjectMocks
    Kartica kartica; // SUT

    @Mock
    private Racun racun;

    AutoCloseable closeable;

    @BeforeEach
    void setUp(){
        closeable = MockitoAnnotations.openMocks(this);
    }
    @AfterEach
    void close() throws Exception {
        closeable.close();
    }



    @Test
    public void placnanjeBlokiranimRacunom(){
        //arrange
        when(racun.umanjiSredstva(anyDouble()))
                .thenReturn(RezultatTranskacije.NEUSPESNO_BLOKIRAN_RACUN);
        kartica.setDnevnaSuma(0);
        kartica.setBlokirana(false);
        kartica.setLimitPoTranskaciji(5000);
        kartica.setDnevniLimit(40000);
        double iznos = 100;

        // act
        BlokiranRacunException exception = assertThrows(BlokiranRacunException.class,
                ()->kartica.izvriPlacanje(iznos)
        );

        // assert
        assertEquals("Racun je blokiran.", exception.getMessage());
    }

    @Test
    public void zbirDolaznihTransakcijaTest(){
        // arrange
        Transkacija t1 = new Transkacija(10, TipTranskacije.DOLAZNA, RezultatTranskacije.USPESNO);
        Transkacija t2 = new Transkacija(20, TipTranskacije.DOLAZNA, RezultatTranskacije.GRESKA);
        Transkacija t3 = new Transkacija(30, TipTranskacije.DOLAZNA, RezultatTranskacije.NEUSPESNO_BLOKIRAN_RACUN);
        Transkacija t4 = new Transkacija(40, TipTranskacije.DOLAZNA, RezultatTranskacije.USPESNO);
        List<Transkacija> lista = Arrays.asList(t1, t2, t3, t4);

        when(racun.fitlterTranskacija(any(Date.class), any(Date.class), eq(TipTranskacije.DOLAZNA)))
                .thenReturn(lista);
        Date start = new Date();
        Date end = new Date();
        TipTranskacije tip = TipTranskacije.DOLAZNA;

        // act
        double rezultat = kartica.iznosTranskacija(start, end, tip);

        // assert
        assertEquals(50.0, rezultat, 0.001);
    }

    @Test
    public void zbirOdlaznihTransakcijaKadaSeDobijeMesovitaListaTest(){
        // arrange
        Transkacija t1 = new Transkacija(10, TipTranskacije.ODLAZNA, RezultatTranskacije.USPESNO);
        Transkacija t2 = new Transkacija(20, TipTranskacije.ODLAZNA, RezultatTranskacije.USPESNO);
        Transkacija t3 = new Transkacija(30, TipTranskacije.DOLAZNA, RezultatTranskacije.USPESNO);
        Transkacija t4 = new Transkacija(40, TipTranskacije.ODLAZNA, RezultatTranskacije.USPESNO);
        List<Transkacija> lista = Arrays.asList(t1, t2, t3, t4);

        when(racun.fitlterTranskacija(any(Date.class), any(Date.class), eq(TipTranskacije.ODLAZNA)))
                .thenReturn(lista);
        Date start = new Date();
        Date end = new Date();
        TipTranskacije tip = TipTranskacije.ODLAZNA;

        // act
        double rezultat = kartica.iznosTranskacija(start, end, tip);

        // assert
        assertEquals(-40.0, rezultat, 0.001);
    }


}