package pmf.imi.mobilnatelefonija;

public class OdabirPaketa {

    private int brojMinuta = 100;
    private int brojPoruka = 300;
    private boolean porodicniPaket = false;

    private int brojGigabajta = 1;

    private String gb = "1GB";

    public int getBrojMinuta() {
        return brojMinuta;
    }

    public void setBrojMinuta(int brojMinuta) {
        this.brojMinuta = brojMinuta;
    }

    public int getBrojPoruka() {
        return brojPoruka;
    }

    public void setBrojPoruka(int brojPoruka) {
        this.brojPoruka = brojPoruka;
    }

    public boolean isPorodicniPaket() {
        return porodicniPaket;
    }

    public void setPorodicniPaket(boolean porodicniPaket) {
        this.porodicniPaket = porodicniPaket;
    }

    public String getGb() {
        return gb;
    }

    public void setGb(String gb) {
        this.gb = gb;
        String broj = gb.substring(0,1);
        this.brojGigabajta = (int) Integer.parseInt(broj);
    }

    public int getBrojGigabajta() {
        return brojGigabajta;
    }


    public String izracunajCenuUsluge(){
        if (brojMinuta < 100){
            return "Broj minuta mora biti između 100 i 300.";
        }
        if (brojPoruka < 0){
            return  "Broj poruka ne sme biti negativan.";
        }

        int cenaPorka = 100;
        if (brojPoruka > 500 && brojPoruka < 100){
            cenaPorka = 200;
        }
        else if (brojPoruka > 1000){
            cenaPorka = 500;
        }
        int cena = brojMinuta * 2 + cenaPorka + brojGigabajta * 400;
        if (porodicniPaket){
            cena = cena - 400;
        }
        return "Cena paketa je "+ cena + " dinara.";
    }
}
