package pmf.imi.ebank;

import java.util.Date;
import java.util.List;

public class Kartica {

    Racun racun;

    boolean blokirana;

    double dnevniLimit;
    double limitPoTranskaciji;

    double dnevnaSuma;
    public Kartica(){

    }

    public boolean izvriPlacanje(double iznos) throws BlokiranRacunException {
        if (blokirana == false && iznos <= limitPoTranskaciji) {
            if ((iznos + dnevnaSuma) <= dnevniLimit ){
                RezultatTranskacije rezultatTranskacije = racun.umanjiSredstva(iznos);
                if (rezultatTranskacije == RezultatTranskacije.USPESNO)
                {
                    return true;
                }
                else if (rezultatTranskacije == RezultatTranskacije.NEUSPESNO_BLOKIRAN_RACUN){
                    throw new BlokiranRacunException();
                }
            }
            return false;
        }
        return false;
    }

    public double stanjeNaRacunu() throws BlokiranRacunException {
        if (racun.isBlokiran()){
            throw new BlokiranRacunException();
        }
        return racun.getStanje();
    }

    public double iznosTranskacija(Date odDana, Date doDana, TipTranskacije tipTranskacije){
        double suma = 0;
        List<Transkacija> transkacije = racun.fitlterTranskacija(odDana, doDana, tipTranskacije);
        for (Transkacija transkacija: transkacije) {
            if (transkacija.rezultatTranskacije == RezultatTranskacije.USPESNO){
                if (tipTranskacije == TipTranskacije.DOLAZNA){
                    suma += transkacija.iznos;
                }
                else {
                    suma -= transkacija.iznos;
                }
            }
        }
        return suma;
    }

    public Racun getRacun() {
        return racun;
    }

    public void setRacun(Racun racun) {
        this.racun = racun;
    }

    public boolean isBlokirana() {
        return blokirana;
    }

    public void setBlokirana(boolean blokirana) {
        this.blokirana = blokirana;
    }

    public double getDnevniLimit() {
        return dnevniLimit;
    }

    public void setDnevniLimit(double dnevniLimit) {
        this.dnevniLimit = dnevniLimit;
    }

    public double getLimitPoTranskaciji() {
        return limitPoTranskaciji;
    }

    public void setLimitPoTranskaciji(double limitPoTranskaciji) {
        this.limitPoTranskaciji = limitPoTranskaciji;
    }

    public double getDnevnaSuma() {
        return dnevnaSuma;
    }

    public void setDnevnaSuma(double dnevnaSuma) {
        this.dnevnaSuma = dnevnaSuma;
    }
}
