package pmf.imi.ebank;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class Racun {

    private String brojRacuna;
    private double stanje;
    private boolean blokiran;

    private List<Transkacija> transakcije = new ArrayList<Transkacija>();

    public List<Transkacija> getTransakcije() {
        return transakcije;
    }

    public void setTransakcije(List<Transkacija> transakcije) {
        this.transakcije = transakcije;
    }

    public Racun() {
    }
    public Racun(String brojRacuna, double stanje, boolean blokiran, List<Transkacija> transakcije) {
        this.brojRacuna = brojRacuna;
        this.stanje = stanje;
        this.blokiran = blokiran;
        this.transakcije = transakcije;
    }

    public String getBrojRacuna() {
        return brojRacuna;
    }

    public void setBrojRacuna(String brojRacuna) {
        this.brojRacuna = brojRacuna;
    }

    public double getStanje() {
        return stanje;
    }

    public void setStanje(double stanje) {
        this.stanje = stanje;
    }

    public boolean isBlokiran() {
        return blokiran;
    }

    public void setBlokiran(boolean blokiran) {
        this.blokiran = blokiran;
    }

    public RezultatTranskacije umanjiSredstva(double iznos){
        if (isBlokiran() == false){
            stanje -= iznos;
            transakcije.add(new Transkacija(iznos,TipTranskacije.ODLAZNA,RezultatTranskacije.USPESNO));
            return RezultatTranskacije.USPESNO;
        }
        transakcije.add(new Transkacija(iznos,TipTranskacije.ODLAZNA,RezultatTranskacije.NEUSPESNO_BLOKIRAN_RACUN));
        return RezultatTranskacije.NEUSPESNO_BLOKIRAN_RACUN;
    }
    public RezultatTranskacije dodajSredstva(double iznos){
        if (isBlokiran()){
            stanje += iznos;
            transakcije.add(new Transkacija(iznos,TipTranskacije.DOLAZNA,RezultatTranskacije.USPESNO));
            return RezultatTranskacije.USPESNO;
        }
        return RezultatTranskacije.NEUSPESNO_BLOKIRAN_RACUN;
    }

    public RezultatTranskacije rezervisiSredstva(double iznos, Racun zaRacun){
        if (isBlokiran() == false){
            if (iznos <= stanje){
                stanje -= iznos;
                RezultatTranskacije status = zaRacun.dodajSredstva(stanje);
                if (status  == RezultatTranskacije.USPESNO){
                    transakcije.add(new Transkacija(iznos,TipTranskacije.ODLAZNA,RezultatTranskacije.USPESNO));
                    return RezultatTranskacije.USPESNO;
                }
                stanje += iznos;
                transakcije.add(new Transkacija(iznos,TipTranskacije.ODLAZNA,RezultatTranskacije.GRESKA));
                return RezultatTranskacije.GRESKA;
            }

        }
        transakcije.add(new Transkacija(iznos,TipTranskacije.ODLAZNA,RezultatTranskacije.NEUSPESNO_BLOKIRAN_RACUN));
        return RezultatTranskacije.NEUSPESNO_BLOKIRAN_RACUN;
    }

    public boolean isDovoljnoSredstava(double iznos){
        return iznos <= stanje;
    }


    public List<Transkacija> fitlterTranskacija(Date odDana, Date doDana, TipTranskacije tipTranskacije){
        List<Transkacija> lista = new ArrayList<>();
        for (int i = 0; i < transakcije.size(); i++) {
            if (odDana.before(transakcije.get(i).datum)
                    && odDana.after(transakcije.get(i).datum)
                    && tipTranskacije == transakcije.get(i).tipTranskacije){
                lista.add(transakcije.get(i));
            }
        }
        return lista;
    }

}
