package pmf.imi;

import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class CompanyPage extends BasePage {

    public static final String URL = "http://localhost:8080/kts-2023-24/kompanija.php?id=";

    @FindBy(xpath = "//p[contains(text(), \"aktivnih oglasa\")]")
    private WebElement activePosts;

    @FindBy(tagName = "img")
    private WebElement image;

    @FindBy(xpath = "//h1[@id='nazivKomapnije']/span")
    private WebElement companyName;

    @FindBy(linkText = "Prikazi oglase kompanije")
    private WebElement showPostsButton;

    public CompanyPage(WebDriver webDriver) {
        super(webDriver);
    }

    int getActivePosts() {
        return Integer.parseInt(activePosts.getText().split(":")[1].trim());
    }

    String getImageSrc() {
        return image.getAttribute("src");
    }

    String getImageAlt() {
        return image.getAttribute("alt");
    }

    String getCompanyName() {
        return companyName.getText();
    }

    HomePage setShowPostsButton() {
        showPostsButton.click();
        return new HomePage(webDriver);
    }
}
