package pmf.imi;

import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.Select;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.net.InetAddress;
import java.time.Duration;
import java.util.List;

public class HomePage extends BasePage {

    public static final String URL = "http://localhost:8080/kts-2023-24/index.php";
    private static final Logger LOGGER = LoggerFactory.getLogger(HomePage.class);

    @FindBy(linkText = "//a[contains(text(), \"ODJAVI SE\")]")
    private WebElement logout;

    @FindBy(xpath = "//div[contains(@class, 'izdvojeni-oglas')]")
    private List<WebElement> featuredPost;

    @FindBy(xpath = "//div[contains(@class, 'izdvojeni-oglas')]//h3/a")
    private List<WebElement> getFeaturedPostLinks;

    @FindBy(xpath = "//div[@id='svi_oglasi']/div/div")
    private List<WebElement> posts;

    @FindBy(id = "pretraga")
    private WebElement searchInput;

    @FindBy(xpath = "//input[@id='pretraga']//following-sibling::div/button")
    private WebElement searchSubmit;

    @FindBy(id = "brojac")
    private WebElement numberOfPosts;

    @FindBy(id = "inlineCheckboxNacinRadaHibridni")
    private WebElement hybridCheckBox;

    @FindBy(id = "inlineCheckboxNacinRadaRemote")
    private WebElement remoteCHeckBox;

    @FindBy(xpath = "//button[@type='submit' and contains(@class, \"warning\")]")
    private WebElement bigSearchButton;

    @FindBy(id = "senioritet")
    private WebElement senioritySelect;

    @FindBy(id = "inlineRadioMestoKragujevac")
    private WebElement kragujevacCheck;

    @FindBy(id = "inlineRadioMestoKraljevo")
    private WebElement kraljevoCheck;

    @FindBy(id = "inlineRadioMestoBeograd")
    private WebElement beogradCheck;

    @FindBy(id = "inlineRadioMestoNovi Sad")
    private WebElement noviSadCheck;

    @FindBy(id = "inlineRadioMestoNis")
    private WebElement nisCheck;

    @FindBy(id = "radijus")
    private WebElement radius;

    public HomePage(WebDriver webDriver) {
        super(webDriver);
    }

    void logOut() {
        // klik na logout dugme
        WebElement x = webDriver.findElement(By.xpath("//a[contains(text(), \"ODJAVI SE\")]"));
        JavascriptExecutor js = ((JavascriptExecutor) webDriver);
        js.executeScript("arguments[0].click()", x);
    }

    int getFeaturedPostSize() {
        return featuredPost.size();
    }

    List<String> getFeaturedPostLinks() {
        return getFeaturedPostLinks.stream()
                .map(post -> post.getAttribute("href"))
                .toList();
    }

    void enterSearch(String value) {
        this.searchInput.sendKeys(value);
    }

    void submitSearch() {
        searchSubmit.click();
    }

    List<Post> getJobPostResult() {
        return posts.stream()
                .map(Post::new)
                .toList();
    }

    int getNumberOfPosts() {
        return Integer.parseInt(numberOfPosts.getText().split(":")[1].trim());
    }

    void clickHybrid() {
        hybridCheckBox.click();
    }

    void clickRemote() {
        remoteCHeckBox.click();
    }
    void search() {
        bigSearchButton.click();
    }

    boolean isHybridSelected() {
        return hybridCheckBox.isSelected();
    }

    boolean isRemoteSelected() {
        return remoteCHeckBox.isSelected();
    }

    void selectSeniority(String value) {
        Select select = new Select(senioritySelect);
        select.selectByVisibleText(value);
    }

    void setRadius(int value) {
        radius.sendKeys(String.valueOf(value));
    }

    void checkKragujevac() {
        kragujevacCheck.click();
    }

    void checkCity(String city) {
        if(city.equalsIgnoreCase("Kraljevo")){
            kraljevoCheck.click();
        } else if (city.equalsIgnoreCase("Kragujevac")) {
            kragujevacCheck.click();
        } else if (city.equalsIgnoreCase("Beograd")) {
            beogradCheck.click();
        } else if (city.equalsIgnoreCase("Novi Sad")) {
            noviSadCheck.click();
        } else if (city.equalsIgnoreCase("Nis")){
            nisCheck.click();
        }else {
            LOGGER.error("City " + city +" not implemented!");
        }
    }

    PostPage goToPostPage(int id) {
        webDriver.get(PostPage.URL + id);
        return new PostPage(webDriver);
    }

    CompanyPage goToCompanyPage(int id) {
        webDriver.get(CompanyPage.URL + id);
        return new CompanyPage(webDriver);
    }
}
