package pmf.imi;

import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class Post {

    private String company;
    private String position; //title
    private String seniority;
    private String city;

    public Post(WebElement webElement) {
        this.company = webElement.findElement(By.xpath("./strong/a")).getText();
        this.position = webElement.findElement(By.xpath("./h3/a")).getText();
        this.seniority = webElement.findElements(By.tagName("p")).get(0).getText();
        this.city = webElement.findElements(By.tagName("p")).get(1).getText();
    }

    public String getCompany() {
        return company;
    }

    public String getPosition() {
        return position;
    }

    public String getSeniority() {
        return seniority;
    }

    public String getCity() {
        return city;
    }
}
