package pmf.imi;

import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

import java.time.Duration;

public class LoginPage extends BasePage {

    public static final String URL = "http://localhost:8080/kts-2023-24/login.php";

    @FindBy(id = "korisnicko")
    private WebElement username;

    @FindBy(id = "lozinka")
    private WebElement password;

    @FindBy(name = "prijava")
    private WebElement loginSubmit;

    @FindBy(xpath = "//div[contains(text(), 'pogresna lozinka')]")
    private WebElement errorMessage;

    public LoginPage(WebDriver webDriver) {
        super(webDriver);
        // dodao krstic

    }

    void setUsername(String username) {
        this.username.sendKeys(username);
    }

    void setPassword(String password) {
        this.password.sendKeys(password);
    }

    HomePage submitLogin() {
        this.loginSubmit.click();
        return new HomePage(webDriver);
    }

    String submitLoginWithError() {
        this.loginSubmit.click();

        WebDriverWait webDriverWait = new WebDriverWait(webDriver, Duration.ofSeconds(5));
        return webDriverWait.until(ExpectedConditions.visibilityOf(errorMessage)).getText();
    }
}
