package pmf.imi;

import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

import java.util.List;

public class PostPage extends BasePage {

    public static final String URL = "http://localhost:8080/kts-2023-24/oglas.php?id=";

    @FindBy(xpath = "//h4[contains(text(), \"rada\")]/following-sibling::p")
    private WebElement wayOfWork;

    @FindBy(xpath = "//h4[contains(text(), \"Detalji\")]/following-sibling::p")
    private WebElement description;

    @FindBy(tagName = "h4")
    private List<WebElement> subtitles;

    public PostPage(WebDriver webDriver) {
        super(webDriver);
    }

    String getWayOfWork() {
        return wayOfWork.getText();
    }

    List<String> getSubtitles() {
        return subtitles.stream()
                .map(WebElement::getText)
                .toList();
    }

    String getDescription() {
        return description.getText();
    }
}
