package pmf.imi;

import io.github.bonigarcia.wdm.WebDriverManager;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.edge.EdgeDriver;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.Test;

import java.util.List;

import static org.testng.Assert.*;

public class CompanyPageTest {

    private WebDriver webDriver;
    private HomePage homePage;
    private CompanyPage companyPage;

    @BeforeSuite
    public void beforeSuite() {
        WebDriverManager.edgedriver().setup();
    }
    @BeforeMethod
    public void setUp() {
        webDriver = new EdgeDriver();
        webDriver.get(LoginPage.URL);

        LoginPage loginPage = new LoginPage(webDriver);
        loginPage.setUsername("kts");
        loginPage.setPassword("kts");
        homePage = loginPage.submitLogin();
    }

    @AfterMethod
    public void tearDown() {
        webDriver.close();
    }

    @Test
    public void activePostsTransPerfect() {
        companyPage = homePage.goToCompanyPage(4);

        int active = companyPage.getActivePosts();

        assertEquals(active, 5);
    }

    @Test
    public void innovatecImageAndName() {
        companyPage = homePage.goToCompanyPage(2);

        String imageSrc = companyPage.getImageSrc();
        String alt = companyPage.getImageAlt();
        String name = companyPage.getCompanyName();

        assertFalse(imageSrc.isEmpty());
        assertEquals(alt, name);
    }

    @Test
    public void comtradeBackToHomePage() {
        companyPage = homePage.goToCompanyPage(1);

        HomePage newHomePage = companyPage.setShowPostsButton();
        assertNotNull(newHomePage);

        List<Post> posts = newHomePage.getJobPostResult();
        posts.forEach(post -> assertEquals(post.getCompany(), "Comtrade"));
    }
}