package pmf.imi;

import io.github.bonigarcia.wdm.WebDriverManager;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.edge.EdgeDriver;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.Test;

import static org.testng.Assert.*;

public class LoginPageTest {

    private WebDriver webDriver;
    private LoginPage loginPage;

    @BeforeSuite
    public void beforeSuite() {
        //WebDriverManager.chromedriver().setup();
        WebDriverManager.edgedriver().setup();

    }
    @BeforeMethod
    public void setUp() {
        webDriver = new EdgeDriver();
        webDriver.get(LoginPage.URL);
//        webDriver.navigate().to(LoginPage.URL);

        loginPage = new LoginPage(webDriver);
    }

    @AfterMethod
    public void tearDown() {
        webDriver.close();
    }

    @Test
    public void loginSuccess() {
        loginPage.setUsername("kts");
        loginPage.setPassword("kts");

        HomePage homePage = loginPage.submitLogin();

        assertNotNull(homePage);
        assertEquals(homePage.getURL(), HomePage.URL);
    }

    @Test
    public void loginUnsuccessful() {
        loginPage.setUsername("kts");
        loginPage.setPassword("123");

        String message = loginPage.submitLoginWithError();

        assertNotNull(message);
        assertEquals(message, "Netacno korisnicko ime ili lozinka.");
    }

}