package pmf.imi;

import io.github.bonigarcia.wdm.WebDriverManager;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.edge.EdgeDriver;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.Test;

import java.util.List;

import static org.testng.Assert.*;

public class PostPageTest {

    private WebDriver webDriver;
    private HomePage homePage;
    private PostPage postPage;

    @BeforeSuite
    public void beforeSuite() {
        WebDriverManager.edgedriver().setup();
    }
    @BeforeMethod
    public void setUp() {
        webDriver = new EdgeDriver();
        webDriver.get(LoginPage.URL);

        LoginPage loginPage = new LoginPage(webDriver);
        loginPage.setUsername("kts");
        loginPage.setPassword("kts");
        homePage = loginPage.submitLogin();
    }

    @AfterMethod
    public void tearDown() {
        webDriver.close();
    }

    @Test
    public void fullStackDev() {
        postPage = homePage.goToPostPage(3);
        assertNotNull(postPage);

        List<String> subtitles = postPage.getSubtitles();
        assertEquals(postPage.getWayOfWork(), "Remote");
        assertTrue(subtitles.contains("Plata"));
    }

    @Test
    public void juniorDev() {
        postPage = homePage.goToPostPage(4);
        assertNotNull(postPage);

        String description = postPage.getDescription();
        assertNotNull(description);
        assertTrue(description.contains("SwiftUI"));
    }
}