<?php


class Db
{
    const host = "localhost"; // podesiti ogvarajucu putanju i port
    const dbname = "oglasimi";
    const user = "root";
    const pass = "";
    
    private $dbh;
    
    function __construct() 
    {
        try
        {
            $string = "mysql:host=".self::host.";dbname=".self::dbname;
            $this->dbh = new PDO($string, self::user, self::pass);
        } catch (Exception $ex) 
        {
            echo "greska prilikom konekcije sa bazom!";
            die();
        }
    }
    function __destruct() 
    {
        $this->dbh = null;
    }
    function proveriKorisnika($user, $pass)
    {
        $pass = sha1($pass);
        $sql = "select * from korisnik where username = '$user' and password = '$pass'";
        $upit = $this->dbh->query($sql);
        return $upit->fetch(PDO::FETCH_ASSOC);
    }

    public function OglasById($idOglasa)
    {
        $sql = "SELECT o.*, s.naziv AS 'senioritet', k.ime AS 'kompanija', k.slika FROM oglas o JOIN kompanija k ON o.id_kompanije = k.id JOIN senioritet s ON o.id_senioritet = s.id";
        $sql = $sql." WHERE o.id = ".$idOglasa;
        $upit = $this->dbh->query($sql);
        return $upit->fetch(PDO::FETCH_ASSOC);
    }


    public function IzdvojeniOglasi()
    {
        
        $sql = "SELECT o.*, s.naziv AS 'senioritet', k.ime AS 'kompanija', k.slika FROM oglas o JOIN kompanija k ON o.id_kompanije = k.id JOIN senioritet s ON o.id_senioritet = s.id";
        $sql = $sql." WHERE o.izdvojen = 1 AND o.datum_isteka >= CURDATE()";
        $upit = $this->dbh->query($sql);
        $oglasi = $upit->fetchAll(PDO::FETCH_ASSOC);
        return $oglasi;
    }

    public function SpisakOglasa($naslov, $id_kompanije, $mesto, $nacin_rada, $id_senioritet, $sortiranje)
    {

        $sql = "SELECT o.*, s.naziv AS 'senioritet', k.ime AS 'kompanija', k.slika FROM oglas o JOIN kompanija k ON o.id_kompanije = k.id JOIN senioritet s ON o.id_senioritet = s.id";
        $sql = $sql." WHERE o.datum_isteka >= CURDATE()";
        if ($naslov != "")
        {
            $sql = $sql." AND o.naslov LIKE '%".$naslov."%'";
        }
        if ($id_kompanije != "")
        {
            $sql = $sql." AND o.id_kompanije = ".$id_kompanije;
        }

        if ($mesto != "") 
        {
            $sql = $sql." AND o.mesto LIKE '".$mesto."'";
        }

        if (count($nacin_rada) > 0 &&  in_array("svi", $nacin_rada) == false) 
        {
            $sql = $sql." AND o.nacin_rada IN ('".implode("','", $nacin_rada)."')";
        }

        if ($id_senioritet != "") 
        {
            $sql = $sql." AND o.id_senioritet = ".$id_senioritet;
        }

        if ($sortiranje != "") 
        {
            $sql = $sql." AND o.izdvojen = ".$izdvojen;
        }

        $sql = $sql." ORDER BY o.datum_isteka ".$sortiranje;

        $upit = $this->dbh->query($sql);
        $oglasi = $upit->fetchAll(PDO::FETCH_ASSOC);

        return $oglasi;
    }


    public function SpisakKompanija()
    {
        $sql = "SELECT * FROM kompanija";
        $upit = $this->dbh->query($sql);
        $kompanija = $upit->fetchAll(PDO::FETCH_ASSOC);
        return $kompanija;
        
    }

    public function SpisakNacinaRada(){
        $sql = "SELECT * FROM nacin_rada";
        $upit = $this->dbh->query($sql);
        $tipovi = $upit->fetchAll(PDO::FETCH_ASSOC);
        return $tipovi;
    }

    public function SpisakSenioriteta(){
        $sql = "SELECT * FROM senioritet";
        $upit = $this->dbh->query($sql);
        $tipovi = $upit->fetchAll(PDO::FETCH_ASSOC);
        return $tipovi;
    }

    public function SpisakMesta(){
        $sql = "SELECT * FROM mesto";
        $upit = $this->dbh->query($sql);
        $tipovi = $upit->fetchAll(PDO::FETCH_ASSOC);
        return $tipovi;
    }



    public function KomapnijaById($id_kompanije)
    {
        $sql = "SELECT * FROM kompanija";
        $sql = $sql." WHERE id = ".$id_kompanije;
        $upit = $this->dbh->query($sql);
        $kompanija =  $upit->fetch(PDO::FETCH_ASSOC);

        
        $sql = "SELECT COUNT(*) FROM `oglas` WHERE id_kompanije = ".$id_kompanije;
        $upit = $this->dbh->query($sql);
        $kompanija['broj_svih_oglasa'] = (int) $upit->fetchColumn();
        

        $sql = "SELECT COUNT(*) FROM `oglas` WHERE id_kompanije = ".$id_kompanije." AND datum_isteka >= CURDATE()";
        $upit = $this->dbh->query($sql);
        $kompanija['broj_aktivnih_oglasa'] = (int) $upit->fetchColumn();

        return $kompanija;
    }
}
?>