<?php
session_start();
if(!isset($_SESSION['autorizovan']))
    header("Location: login.php");
require_once 'db.php';

$db = new Db();



$naslov_pretraga = "";
$kompanija_pretraga = "";
$mesto_pretraga = "";
$nacin_rada = array();
$senioritet_pretraga = "";
$sortiranje = "";

$postoji_pretraga = false;


if(isset($_GET['logout']))
{
    setcookie("user",1,time() - 1);
    setcookie("pass",1,time() - 1);
    session_destroy();
    header("Location: login.php");
}

if (isset($_GET['search_naslov']) && $_GET['search_naslov'] != "" ) {
    $naslov_pretraga = $_GET['search_naslov'];
    $postoji_pretraga = true;
}
if (isset($_GET['search_kompanija']) &&  $_GET['search_kompanija'] != "" ) {
    $kompanija_pretraga = $_GET['search_kompanija'];
    $postoji_pretraga = true;
}
if (isset($_GET['search_mesto']) &&  $_GET['search_mesto'] != "" ) {
    $mesto_pretraga = $_GET['search_mesto'];
    $postoji_pretraga = true;
}
if (isset($_GET['search_nacin_rada']) &&  $_GET['search_nacin_rada'] != "" ) {
    $nacin_rada = $_GET['search_nacin_rada'];
    // var_dump($nacin_rada);
    // echo implode(",", $nacin_rada);
    $postoji_pretraga = true;
}
if (isset($_GET['search_senioritet']) &&  $_GET['search_senioritet'] != "" ) {
    $senioritet_pretraga = $_GET['search_senioritet'];
    $postoji_pretraga = true;
}
if (isset($_GET['search_sort']) &&  $_GET['search_sort'] != "" ) {
    $sortiranje = $_GET['search_sort'];
    $postoji_pretraga = true;
}

$oglasi = $db->SpisakOglasa($naslov_pretraga, $kompanija_pretraga, $mesto_pretraga, $nacin_rada, $senioritet_pretraga, $sortiranje);
$izdvojeniOglasi = $db->IzdvojeniOglasi();
$kompanije = $db->SpisakKompanija();
$naciniRada = $db->SpisakNacinaRada();
$senioriteti = $db->SpisakSenioriteta();
$mesta = $db->SpisakMesta();

?>

<!DOCTYPE html>
<html lang="en">
<head>
  <title>OglasIMI</title>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js"></script>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
  <style>
    .detalj {
        border: 1px solid black;
        padding: 4px;
    }

    .detalj.detalj-kompanija {
        background-color: #c3c3c3;
        color: #005FFF
    }
  </style>
</head>
<body>

<div class="container-fluid p-5 bg-secondary text-white text-center">
  <h1>OglasIMI</h1>
  <p>Najveca baza IT poslova u Srbiji</p> 
</div>
  
<div class="container mt-5">
  <div class="row">
    <?php 
        foreach($izdvojeniOglasi as $izdvojen){
            ?>
                <div class="col-sm-4 izdvojeni-oglas">
                    <h3 class='detalj'><?php echo $izdvojen['naslov'] ?> </h3>
                    <?php 
                        $kompanija = $izdvojen['kompanija'];
                        if (!empty($kompanija)) {
                            echo "<span class='detalj detalj-kompanija'><a href='kompanija.php?id=".$izdvojen['id_kompanije']."'>".$kompanija."</a></span>";
                        }
                    ?>
                    <span class='detalj'><?php echo $izdvojen['mesto'] ?></span>
                    <span class='detalj'><?php echo $izdvojen['senioritet'] ?></span>

                </div>
                
            <?php
        }
    ?>
  </div>
</div>


<div class="container mt-5">
  <!-- <div class="row"> -->
    <form action="" method="GET" >
        <div class="form-group row">
            <div class="col-sm-8">
                    <label for="pretraga" class="form-label">Pretraga oglsa:</label>
                    <div class="input-group">
                        <input type="text" class="form-control" placeholder="Pretraga oglasa"  name="search_naslov" id="pretraga" >
                        <div class="input-group-btn">
                            <button class="btn btn-secondary" type="submit"><i class="bi bi-search"></i></button>
                        </div>
                    </div>
            </div>
            <div class="col-sm-4">
                    <label for="s_kompanija" class="form-label">Kompanija:</label>
                    <select  name="search_kompanija" class="form-control" id="s_kompanija">
                        <option value="">Sve kompaije</option>
                        <?php 
                            foreach($kompanije as $kompanija){
                                ?>
                                    <option value="<?php echo $kompanija['id'] ?>"> <?php echo $kompanija['ime'] ?> </option>
                                <?php
                            }
                        ?>
                    </select>
            </div>
        </div>
        <br/>
        <div class="form-group row">
            <div class="col-sm-6">
                Odaberite način rada: <br>
                <div class="form-check form-check-inline">
                    <input  name="search_nacin_rada[]" class="form-check-input" type="checkbox" id="inlineCheckboxNacinRadaSvi" value="svi">
                    <label class="form-check-label" for="inlineCheckboxNacinRadaSvi">Svi</label>
                </div>
                <?php 
                        foreach($naciniRada as $nacinRada){
                            ?>  <div class="form-check form-check-inline">
                                    <input  name="search_nacin_rada[]" class="form-check-input" type="checkbox" id="inlineCheckboxNacinRada<?php echo $nacinRada['naziv']?>" value="<?php echo $nacinRada['naziv']?>">
                                    <label class="form-check-label" for="inlineCheckboxNacinRada<?php echo $nacinRada['naziv']?>"><?php echo $nacinRada['naziv']?></label>
                                </div>
                            <?php 
                        } ?>
                    
            </div>
            <div class="col-sm-6">
                Odaberite mesto rada: <br>
                <div class="form-check form-check-inline">
                    <input class="form-check-input" type="radio" name="search_mesto" id="inlineRadioMesto" value=""
                        <?php if ( isset($_GET['search_mesto']) &&  $_GET['search_mesto'] == "" )  {
                                                echo 'checked';
                                            } ?>
                        
                        >
                    <label class="form-check-label" for="inlineRadioMesto">Sva mesta</label>
                </div>
                <?php 
                    foreach($mesta as $mesto){
                        ?>
                            <div class="form-check form-check-inline">
                                <input class="form-check-input" type="radio" name="search_mesto" 
                                    id="inlineRadioMesto<?php echo $mesto['naziv'] ?>" value="<?php echo $mesto['naziv'] ?>" 
                                        <?php if ( isset($_GET['search_mesto']) &&  $_GET['search_mesto'] == $mesto['naziv'] )  {
                                            echo 'checked';
                                        } ?>
                                    >
                                <label class="form-check-label" for="inlineRadioMesto<?php echo $mesto['naziv'] ?>"><?php echo $mesto['naziv'] ?></label>
                            </div>
                        <?php
                    }
                ?>

            </div>
        </div>
        <br />
        <div class="form-group row">

            <div class="col-sm-3">
                    <label for="senioritet" class="form-label">Senioritet:</label>
                    <select  name="search_senioritet" class="form-control" id="senioritet">
                        <option value="">Svi senioriteti</option>
                        <?php 
                            foreach($senioriteti as $seniorit){
                                ?>
                                    <option value="<?php echo $seniorit['id'] ?>"
                                        <?php if ( isset($_GET['search_senioritet']) &&  $_GET['search_senioritet'] ==  $seniorit['id'] )  {
                                            echo 'selected';
                                        } ?>
                                    > <?php echo $seniorit['naziv'] ?> </option>
                                <?php
                            }
                        ?>
                    </select>
            </div>
        
            <div class="col-sm-3">
                    <label for="sort" class="form-label">Sortiranje oglasa: </label>
                    <select  name="sort" class="form-control" id="sort">
                        <option value="">Bez sortianja</option>
                        <option value="desc">Najnoviji</option>
                        <option value="asc">Uskoro isticu</option>
                    </select>
            </div>

            <div class="col-sm-3">
                    <label for="radijus" class="form-label">Radijus pretrage (0 - 50 km):</label>
                    <div class="input-group">
                        <input type="number" min="0" max="50" class="form-control" placeholder="Radijus pretrage" id="radijus" >
                        <span class="input-group-text" id="basic-addon2">km</span>
                    </div>
            </div>
            <div class="col-sm-1"></div>
            <div class="col-sm-2">
                <br/>
                <button type="submit" class="btn btn-warning btn-lg"><i class="bi bi-search"></i> Pretraga</button>
            </div>
        </div>
        
    </form>

  <!-- </div> -->
</div>



<div class="container mt-3">
  <h2 id="spisak">Spisak oglasa  </h2>
  <?php
    if ($postoji_pretraga) {
        ?>
            <p id="pamerametri_pretrage">Parametri pretrage: </p>
            <ul>
        <?php 
        if (isset($_GET['search_naslov']) && $_GET['search_naslov'] != ""  ) {
            echo "<li><span class='font-weight-bold'>Pretraga oglasa: </span> ".$_GET['search_naslov'];
        }
        if (isset($_GET['search_kompanija']) && $_GET['search_kompanija'] != "" ) {
            echo "<li><span class='font-weight-bold'>Pretraga kompanije: </span> ".$_GET['search_kompanija'];
        }
        if (isset($_GET['search_mesto']) && $_GET['search_mesto'] != "" ) {
            echo "<li><span class='font-weight-bold'>Pretraga mesta: </span> ".$_GET['search_mesto'];
        }
        if (isset($_GET['search_nacin_rada']) && $_GET['search_nacin_rada'] != "" ) {
            echo "<li><span class='font-weight-bold'>Pretraga nacina rada: </span> ".implode(", ", $_GET['search_nacin_rada']);
        }
        if (isset($_GET['search_senioritet'])&& $_GET['search_senioritet'] != "" ) {
            echo "<li><span class='font-weight-bold'>Pretraga senioriteta: </span> ".$_GET['search_senioritet'];
        }
        if (isset($_GET['search_sort']) && $_GET['search_sort'] != "" ) {
            echo "<li><span class='font-weight-bold'>Sortiranje godina: </span> ".$_GET['search_sort'];
        }
        ?></ul>
        <form id="obrisi-pretragu" action="" method="GET">
            <button type="submit" class="btn btn-secondary">Ponisti pretragu</button>
        </form>
        <br>
        <br>
        <?php
    }
  ?> 
    <p id="brojac" style="text-align: right;">broj prikazanih oglasa: <?php echo count($oglasi) ?></p>
    <div id="svi_oglasi" class="row">
    <?php 
        foreach($oglasi as $oglas){
            ?>
                <div class="card flex-md-row mb-4 box-shadow h-md-250">
                    <div class="card-body d-flex flex-column align-items-start">

                        <?php 
                            $kompanija = $izdvojen['kompanija'];
                            if (!empty($kompanija)) {
                                echo "<strong class='d-inline-block mb-2 text-primary'><a href='kompanija.php?id=".$oglas['id_kompanije']."'>".$oglas['kompanija']."</a></strong>";
                            }
                        ?>

                        <h3 class="mb-0">
                            <a class="dark-text" href="oglas.php?id=<?php echo $oglas['id'] ?>"><?php echo $oglas['naslov'] ?></a>
                        </h3>
                        <div class="mb-1 text-muted"><?php echo $oglas['datum_isteka'] ?></div>
                        <p class="card-text mb-auto" style="font-weight: bold;"><?php echo $oglas['senioritet'] ?></p>
                        <p class="card-text mb-auto" style="font-style: italic;"><?php echo $oglas['mesto'] ?></p>
                        <?php
                            $opis = $oglas['opis'];
                            $opis = (strlen($opis) > 303) ? substr($opis,0,300).'...' : $opis;
                            if (!empty($opis)) {
                                echo "<p>".$opis."</p>";
                            }
                        ?>
                        <a href="oglas.php?id=<?php echo $oglas['id'] ?>">Detaljnije...</a>
                    </div>
                    <img class="card-img-right flex-auto d-none d-md-block" 
                        data-src="holder.js/200x250?theme=thumb" 
                        alt="Thumbnail [200x250]" 
                        style="width: 200px; height: 250px;" 
                        src="<?php echo $oglas['slika'] ?>" 
                        data-holder-rendered="true">
                        
                </div>
            <?php
        }
    ?>
    </div>

  <a href="index.php?logout">ODJAVI SE</a>
</div>

</body>
</html>
