package com.imi.polovniautomobili;

import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

import java.util.List;

public class Car {
    private String imageSource;
    private String manufacturer;
    private String model;

    private String yearOfManufacture;
    private String price;
    public Car(WebElement webElement) {
        List<WebElement> dataFields = webElement.findElements(By.xpath("./td"));
        imageSource = dataFields.get(0).getAttribute("src");
        manufacturer = dataFields.get(1).getText().trim();
        model = dataFields.get(2).getText().trim();
        yearOfManufacture = dataFields.get(3).getText().trim();
        price = dataFields.get(4).getText().trim();
    }

    public String getImageSource() {
        return imageSource;
    }

    public void setImageSource(String imageSource) {
        this.imageSource = imageSource;
    }

    public String getManufacturer() {
        return manufacturer;
    }

    public void setManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
    }

    public String getModel() {
        return model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getYearOfManufacture() {
        return yearOfManufacture;
    }

    public void setYearOfManufacture(String yearOfManufacture) {
        this.yearOfManufacture = yearOfManufacture;
    }

    public String getPrice() {
        return price;
    }

    public void setPrice(String price) {
        this.price = price;
    }

    @Override
    public String toString() {
        return "Car{" +
                "imageSource='" + imageSource + '\'' +
                ", manifacturer='" + manufacturer + '\'' +
                ", model='" + model + '\'' +
                ", yearOfManufacture=" + yearOfManufacture +
                ", price=" + price +
                '}';
    }
}
