package com.imi.polovniautomobili;

import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class FeaturedCar {
    private String model;
    private String description;
    private int price;
    private String imageSource;
    public FeaturedCar(WebElement webElement) {
        WebElement image = webElement.findElement(By.xpath("./img"));
        imageSource = image.getAttribute("src");

        String webElementText = webElement.getText();
        String[] details = webElementText.split("\n");

        model = details[0].trim();
        description = details[1].trim();
        price = Integer.parseInt(details[2]
                .split(": ")[1]
                .trim());
    }

    public String getModel() {
        return model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getPrice() {
        return price;
    }

    public void setPrice(int price) {
        this.price = price;
    }

    public String getImageSource() {
        return imageSource;
    }

    public void setImageSource(String imageSource) {
        this.imageSource = imageSource;
    }

    @Override
    public String toString() {
        return "FeaturedCar{" +
                "model='" + model + '\'' +
                ", description='" + description + '\'' +
                ", price=" + price +
                ", imageSource='" + imageSource + '\'' +
                '}';
    }
}
