package com.imi.polovniautomobili;

import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.Select;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;

public class HomePage extends BasePage {
    private static Logger LOGGER = LoggerFactory.getLogger(Logger.class);
    public static final int WAIT_DURATION_SECONDS = 5;
    public static final String URL = "http://localhost/PolovniAutomobili/index.php";

    @FindBy(xpath = "//div[contains(@class, 'izdvojeni-automobil')]")
    private List<WebElement> featuredCarWebElements;




//    @FindBy(xpath = "//input[@name='search_model']")
//    @FindBy(xpath = "//label[contains(text(), 'Model')]/following-sibling::input")
//    @FindBy(xpath = "//label[contains(text(), 'Model')]/following-sibling::input[@name='search_model']")
    @FindBy(name = "search_model")
    private WebElement modelField;


    @FindBy(xpath = "//table[@id='svi_automobili']/tbody/tr")
    private List<WebElement> searchResults;

    @FindBy(xpath = "//button[.='Pretraga']")
    private WebElement searchButton;

    @FindBy(name = "search_tip")
    private WebElement bodyStyleFilter;


    @FindBy(id = "pamerametri_pretrage")
    private WebElement searchParamsLabel;

    @FindBy(name = "search_proizvodjac")
    private WebElement manufacturerFilter;


    @FindBy(xpath = "//select[@name='search_tip']/option[contains(text(), 'Limuzina')]")
    private WebElement bodyStyleOptionLimuzina;



//    @FindBy(xpath = "//p[@id='pamerametri_pretrage']/following::ul/li")
    @FindBy(css = "#pamerametri_pretrage + ul > li")
    private List<WebElement> searchParams;


    @FindBy(name = "search_cena_do")
    private WebElement priceUpTo;

    @FindBy(name = "search_godina_od")
    private WebElement yearFrom;

    @FindBy(name = "sort")
    private WebElement sort;


    // sve slike koje nisu unutar linka
    //      xpath = //table[@id='svi_automobili']//td//img[not(ancestor::a)]"


    @FindBy(xpath = "//table[@id='svi_automobili']//img")
    private List<WebElement> images;


    public HomePage(WebDriver driver) {
        super(driver);
    }

    public List<FeaturedCar> getFeaturedCars() {
        List<FeaturedCar> featuredCars = new ArrayList<>();

        for (WebElement featuredCarElement : featuredCarWebElements) {
            featuredCars.add(new FeaturedCar(featuredCarElement));
        }

        return featuredCars;
    }

    public void setModelName(String modelName) {
        modelField.sendKeys(modelName);
    }

    public HomePage performSearch() {
        // scroll (ovaj metod nije deo seleniuma; definisan je u BasePage)
        scrollToElement(searchButton, driver);

        searchButton.click();

        WebDriverWait wait =  new WebDriverWait(driver, Duration.ofSeconds(WAIT_DURATION_SECONDS));
        wait.until(ExpectedConditions.visibilityOf(searchButton));

        return new HomePage(driver);
    }

    public List<Car> getSearchResults() {
        List<Car> carResults = new ArrayList<>();

        for (WebElement searchResult : searchResults) {
            carResults.add(new Car(searchResult));
        }

        return carResults;
    }

    public void selectManufacturer(String manufacturer) {
        Select manufacturerFilterSelect = new Select(manufacturerFilter);
        manufacturerFilterSelect.selectByVisibleText(manufacturer);
    }

    public void selectBodyStyle(String bodyStyle) {
        Select bodyStyleSelect = new Select(bodyStyleFilter);
        scrollToElement(bodyStyleFilter, driver);
        bodyStyleSelect.selectByVisibleText(bodyStyle);
    }

    public List<String> getSelectedOptionsForBodyStyle() {
        List<String> selectedOptions = new ArrayList<>();
        Select bodyStyleSelect = new Select(bodyStyleFilter);

        for (WebElement option : bodyStyleSelect.getAllSelectedOptions()) {
            selectedOptions.add(option.getText());
        }

        return selectedOptions;
    }

    public boolean isLimuzinaSelectedAsBodyStyle() {
        return bodyStyleOptionLimuzina.isSelected();
    }

    public boolean isSelected(String optionText) {
        Select bodyStyleSelect = new Select(bodyStyleFilter);
        scrollToElement(bodyStyleFilter, driver);

        for (WebElement option : bodyStyleSelect.getOptions()) {
            if (optionText.equals(option.getText().trim()))
                return option.isSelected();
        }

        return false;
    }


    public List<String> getSearchParams() {
        List<String> params = new ArrayList<>();

        for (WebElement searchParam : searchParams) {
            scrollToElement(searchParam, driver);

            String txt = searchParam.getText()
                    .replace("Pretraga modela: ", "")
                    .replace("Pretraga proizvodjaca: ", "")
                    .replace("Pretraga karoserije: ", "")
                    .replace("Filter cene: ", "")
                    .replace("Filter godina: ", "");

            params.add(txt);
        }

        return params;
    }

    public void setUpToPrice(String price) {
        priceUpTo.sendKeys(price);
    }

    public void setFromManufactureYear(String year) {
        yearFrom.sendKeys(year);
    }

    public void selectSortType(SortType sortType) {
        Select sortTypeSelect = new Select(sort);
        sortTypeSelect.selectByVisibleText(sortType.toString());
    }

    public List<WebElement> getCarImages() {
        return images;
    }

    public boolean isInsideLink(WebElement element) {

        WebElement linkAncestor = element.findElement(By.xpath("ancestor::a[@href!='']"));

        if (linkAncestor != null)
            LOGGER.info("Link href: " + linkAncestor.getAttribute("href"));

        return linkAncestor != null;
    }

    public CarPage visitCarPageById(int id) {
        driver.get(CarPage.BASE_URL + id);
        return new CarPage(driver);
    }

}
