package com.imi.polovniautomobili;

import io.github.bonigarcia.wdm.WebDriverManager;
import org.apache.commons.logging.Log;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.Test;

import java.util.List;

import static org.testng.Assert.*;

public class CarPageTest {
    private static Logger LOGGER = LoggerFactory.getLogger(Logger.class);
    HomePage homePage;
    CarPage carPage;
    WebDriver driver;

    @BeforeSuite
    public void setUpDriverManager() {
        WebDriverManager.firefoxdriver().setup();
    }

    @BeforeMethod
    public void setUp() {
        driver = new FirefoxDriver();
        driver.get(LoginPage.URL);

        LoginPage loginPage = new LoginPage(driver);
        loginPage.setUsername("branko.arsic");
        loginPage.setPassword("pmf#imi");
        homePage = loginPage.submitCredentials();

        driver.manage().window().maximize();
    }

    // 8. a
    @Test
    public void validateManufacturerNameAndFontStyle() {
        // arrange
        carPage = homePage.visitCarPageById(5);

        // act
        String manufacturer = carPage.getManufacturer();
        String manufacturerCss = carPage.getManufacturerAttribute("style");

        // assert
        assertNotNull(manufacturer);
        assertNotNull(manufacturerCss);

        LOGGER.info("Manufacturer label CSS: " + manufacturerCss);

        assertEquals(manufacturer, "Alfa Romeo");
        assertTrue(manufacturerCss.contains("italic"));
    }

    // 8. b
    @Test
    public void validatePriceFormat() {
        // arrange
        carPage = homePage.visitCarPageById(3);

        // act
        String price = carPage.getPrice();

        // assert
        assertNotNull(price);
        assertEquals(price, "47.000");
    }

    // 8. c
    @Test
    public void testModal() {
        // arrange
        carPage = homePage.visitCarPageById(3);

        // act
        carPage.openModal();
        String title = carPage.getModalTitle();
        carPage.exitModal();

        // assert
        assertNotNull(title);
        assertEquals(title, "Model: E 200 D");
        assertFalse(carPage.isModalDisplayed());
    }

    // 8. d
    @Test
    public void testGoBackHomeButton() {
        // arrange
        carPage = homePage.visitCarPageById(3);

        // act
        homePage = carPage.goBackHome();

        // assert
        assertNotNull(homePage);
        String currentUrl = homePage.getUrl().toLowerCase();

        LOGGER.info("Current URL: " + currentUrl);

        assertTrue(currentUrl.contains(HomePage.URL.toLowerCase()));
    }

    @AfterMethod
    public void tearDown() {
        driver.quit();
    }
}
