package com.imi.polovniautomobili;

import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.Select;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;

public class CarPage extends BasePage {
    private static Logger LOGGER = LoggerFactory.getLogger(Logger.class);
    public static final String BASE_URL = "http://localhost/polovniAutomobili/automobil.php?id=";
    public static final int WAIT_DURATION_SECONDS = 5;



//    @FindBy(xpath = "//h2[@id='model']/following-sibling::h3")
    @FindBy(css = "#model ~ h3")
    private WebElement manufacturer;


    @FindBy(xpath = "//*[contains(text(), 'Cena')]")
    private WebElement price;


    @FindBy(xpath = "//div[@onclick='open_modal()']")
    private WebElement modal;


    @FindBy(xpath = "//div[@id='myModal']//*[@class='modal-title']")
    private WebElement modalTitle;


    @FindBy(xpath = "//div[@id='myModal']//*[@class='btn-close']")
    private WebElement modalExitButton;


    @FindBy(linkText = "Vrati se na početnu")
    private WebElement homeLink;

    public CarPage(WebDriver driver) {
        super(driver);
    }

    public String getManufacturer() {
        return manufacturer.getText();
    }

    public String getManufacturerAttribute(String attribute) {
       return manufacturer.getAttribute(attribute);
    }

    public String getPrice() {
        return price.getText().replace("Cena: ", "");
    }

    public void openModal() {
        modal.click();
    }

    public String getModalTitle() {
        WebDriverWait wait = new WebDriverWait(driver, Duration.ofSeconds(WAIT_DURATION_SECONDS));
        WebElement title = wait.until(ExpectedConditions.visibilityOf(modalTitle));
        return title.getText();
    }

    public void exitModal() {
        modalExitButton.click();
    }

    public boolean isModalDisplayed() {
        return modal.isDisplayed();
    }

    public HomePage goBackHome() {
        homeLink.click();
        return new HomePage(driver);
    }


}
