<?php
session_start();
if(!isset($_SESSION['autorizovan']))
    header("Location: login.php");
require_once 'db.php';

$db = new Db();



$model_pretraga = "";
$proizvodjac_pretraga = "";
$tip_pretraga = "";
$cena_do_pretraga = 0;
$godina_od_pretraga = 0;

$postoji_pretraga = false;


if(isset($_GET['logout']))
{
    setcookie("user",1,time() - 1);
    setcookie("pass",1,time() - 1);
    session_destroy();
    header("Location: login.php");
}

if (isset($_GET['search_model']) && $_GET['search_model'] != "" ) {
    $model_pretraga = $_GET['search_model'];
    $postoji_pretraga = true;
}
if (isset($_GET['search_proizvodjac']) &&  $_GET['search_proizvodjac'] != "" ) {
    $proizvodjac_pretraga = $_GET['search_proizvodjac'];
    $postoji_pretraga = true;
}
if (isset($_GET['search_tip']) &&  $_GET['search_tip'] != "" ) {
    $tip_pretraga = $_GET['search_tip'];
    $postoji_pretraga = true;
}
if (isset($_GET['search_cena_do']) &&  $_GET['search_cena_do'] != "" ) {
    $cena_do_pretraga = $_GET['search_cena_do'];
    $postoji_pretraga = true;
}
if (isset($_GET['search_godina_od']) &&  $_GET['search_godina_od'] != "" ) {
    $godina_od_pretraga = $_GET['search_godina_od'];
    $postoji_pretraga = true;
}

$automobili = $db->SpisakAutomobila($model_pretraga, $proizvodjac_pretraga, $tip_pretraga, $cena_do_pretraga, $godina_od_pretraga);
$izdvojeniAutomobili = $db->IzdvojeniAutomobili();
$prozvodjaci = $db->Proizvodjaci();
$karoserije = $db->TipoviKaroserije();

?>

<!DOCTYPE html>
<html lang="en">
<head>
  <title>Polovni automobili</title>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js"></script>
</head>
<body>

<div class="container-fluid p-5 bg-primary text-white text-center">
  <h1>Polovni automobili</h1>
  <p>Najbolja ponuda polovnih automobila u Srbiji</p> 
</div>
  
<div class="container mt-5">
  <div class="row">
    <?php 
        foreach($izdvojeniAutomobili as $izdvojen){
            ?>
                <div class="col-sm-4 izdvojeni-automobil">
                    <img src="<?php echo $izdvojen['slika'] ?>" alt="" width="100%" class="rounded" />
                    <h3> <?php echo $izdvojen['model'] ?> </h3>
                    <p><?php echo $izdvojen['opis'] ?></p>
                    <p> cena: <?php echo $izdvojen['cena'] ?>  </p>
                </div>
                
            <?php
        }
    ?>
  </div>
</div>


<div class="container mt-5">
  <div class="row">
    <form action="" method="GET">
        <div class="col-sm-3">
            <label  class="form-label">Model:</label>
            <input type="text" name="search_model" />
        </div>
        <div class="col-sm-3">
            <label for="pwd" class="form-label">Prozivodjac:</label>
            <select name="search_proizvodjac">
                <option value="">Svi</option>
                <?php 
                    foreach($prozvodjaci as $proizvodjac){
                        ?>
                            <option value="<?php echo $proizvodjac['proizvodjac'] ?>"> <?php echo $proizvodjac['proizvodjac'] ?> </option>
                        <?php
                    }
                ?>
            </select>

        </div>
        <div class="col-sm-3">
            <label for="pwd" class="form-label">Tip karoserije:</label>
            <select name="search_tip">
                <option value="">Svi</option>
                <?php 
                    foreach($karoserije as $karoserija){
                        ?>
                            <option value="<?php echo $karoserija['karoserija'] ?>"> <?php echo $karoserija['karoserija'] ?> </option>
                        <?php
                    }
                ?>
            </select>

        </div>
        <div class="col-sm-3">
            <label class="form-label">cena do:</label>
            <input type="number"  name="search_cena_do" >
        </div>
        <div class="col-sm-3">
            <label class="form-label">godina od:</label>
            <input type="number"  name="search_godina_od" >
        </div>
        
        <div class="col-sm-3">
            <label class="form-label">Sortiranje cene</label>
            <select name="sort">
                <option value="">Bez sortianja</option>
                <option value="rastuce">cena rastuce</option>
                <option value="opadajuce">cena opadajuce</option>
            </select>

        </div>
        
        
        <button type="submit" class="btn btn-primary">Pretraga</button>
    </form>

  </div>
</div>



<div class="container mt-3">
  <h2 id="spisak">Spisak automobila  </h2>
  <p id="brojac" style="text-align: right;">broj prikazanih automobila: <?php echo count($automobili) ?></p>
  <?php
    if ($postoji_pretraga) {
        ?>
            <p id="pamerametri_pretrage">Parametri pretrage: </p>
            <ul>
        <?php 
        if (isset($_GET['search_model']) && $_GET['search_model'] != ""  ) {
            echo "<li><span class='font-weight-bold'>Pretraga modela: </span> ".$_GET['search_model'];
        }
        if (isset($_GET['search_proizvodjac']) && $_GET['search_proizvodjac'] != "" ) {
            echo "<li><span class='font-weight-bold'>Pretraga proizvodjaca: </span> ".$_GET['search_proizvodjac'];
        }
        if (isset($_GET['search_tip']) && $_GET['search_tip'] != "" ) {
            echo "<li><span class='font-weight-bold'>Pretraga karoserije: </span> ".$_GET['search_tip'];
        }
        if (isset($_GET['search_cena_do'])&& $_GET['search_cena_do'] != "" ) {
            echo "<li><span class='font-weight-bold'>Filter cene: </span> ".$_GET['search_cena_do'];
        }
        if (isset($_GET['search_godina_od']) && $_GET['search_godina_od'] != "" ) {
            echo "<li><span class='font-weight-bold'>Filter godina: </span> ".$_GET['search_godina_od'];
        }
        ?></ul>
        <form id="obrisi-pretragu" action="" method="GET">
            <button type="submit" class="btn btn-primary">Ponisti pretragu</button>
        </form>
        <?php
    }
  ?>           
  <table id="svi_automobili" class="table table-striped">
    <thead>
      <tr>
        <th>Slika</th>
        <th>Proizvodjac</th>
        <th>Model</th>
        <th>Godiste</th>
        <th>Cena</th>
        <!-- <th>Detalji</th> -->
      </tr>
    </thead>
    <tbody>
        <?php 
            foreach($automobili as $auto){
                ?>
                      <tr>
                        <td><a href="automobil.php?id=<?php echo $auto['automobil_id'] ?>"  ><img src="<?php echo $auto['slika'] ?>" alt="" width="100px" /></a></td>
                        <td><?php echo $auto['proizvodjac'] ?></td>
                        <td><?php echo $auto['model'] ?></td>
                        <td><?php echo $auto['godina_proizvodnje'] ?></td>
                        <td><?php echo $auto['cena'] ?></td>
                    </tr>
                <?php
            }
        
        ?>
    </tbody>
  </table>
  <a href="index.php?logout">LOG OUT</a>
</div>

</body>
</html>
