package com.imi.polovniautomobili;

import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.PageFactory;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

import java.time.Duration;

public abstract class BasePage {
    WebDriver driver;
    public BasePage(WebDriver driver) {
        this.driver = driver;
        PageFactory.initElements(driver, this);
    }

    public String getUrl() {
        return this.driver.getCurrentUrl();
    }

    protected WebElement scrollToElement(WebElement element, WebDriver driver) {
        // prvi nacin (bolji jer se skroll vrsi sve dok element ne postane vidljiv):
        JavascriptExecutor jse = (JavascriptExecutor) driver;
        // skrola sve dok se donja strana elementa ne poklopi sa donjom stranom view-a
        jse.executeScript("arguments[0].scrollIntoView();", element);

        // drugi nacin:
        // window.scrollBy(0, 1000)"); // scroll-a 1000 piksela na dole

        WebDriverWait wait = new WebDriverWait(driver, Duration.ofSeconds(5));
        return wait.until(ExpectedConditions.elementToBeClickable(element));
    }
}
