package com.imi.polovniautomobili;

import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

import java.time.Duration;

public class LoginPage extends BasePage {
    public static final String URL = "http://localhost/PolovniAutomobili/login.php";
    public static final int WAIT_DURATION_SECONDS = 5;

    @FindBy(id = "korisnicko")
    private WebElement usernameField;
    @FindBy(id = "lozinka")
    private WebElement passwordField;
    @FindBy(xpath = "//form/input[@type=\"submit\"]")
    private WebElement submitButton;

//    @FindBy(xpath = "//p[contains(@style, \"red\")]")
    @FindBy(xpath = "//form/following::p[contains(@style, \"red\")]")
    private WebElement errorMessage;

    public LoginPage(WebDriver driver) {
        super(driver);
    }

    public void setUsername(String username) {
        usernameField.sendKeys(username);
    }

    public void setPassword(String password) {
        // obratiti paznju pri pisanju ove linije
        // cesto se desi da se prekopira usernameField i da se ne promeni na passwordField
        passwordField.sendKeys(password);
    }

    public HomePage submitCredentials() {
//        Ne radi na nekim verzijama Firefox-a zbog sigurnosnih mehanizama za submit event
//        submitButton.submit();

        submitButton.click();

        WebDriverWait wait = new WebDriverWait(driver, Duration.ofSeconds(WAIT_DURATION_SECONDS));

        wait.until(
            ExpectedConditions.not(
                    ExpectedConditions.urlToBe(URL)
            ));

        return new HomePage(driver);
    }

    public String submitCredentialsAndGetErrorMessage() {
        submitButton.click();

        WebDriverWait wait =  new WebDriverWait(driver, Duration.ofSeconds(WAIT_DURATION_SECONDS));
        WebElement locatedErrorMessage = wait.until(ExpectedConditions.visibilityOf(errorMessage));

        return locatedErrorMessage.getText();
    }

    public String getTextColorOfErrorMessage() {
       return errorMessage.getCssValue("color");
    }

    // drugi nacin za proveru boje
    public String getErrorMessageAttribute(String attributeName) {
        return errorMessage.getAttribute(attributeName);
    }
}
