package com.imi.polovniautomobili;

import io.github.bonigarcia.wdm.WebDriverManager;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.Test;
import org.testng.asserts.SoftAssert;

import static org.testng.Assert.*;

public class LoginPageTest {
    LoginPage loginPage;
    WebDriver driver;

    @BeforeSuite
    public void setUpDriverManager() {
        WebDriverManager.firefoxdriver().setup();
    }

    @BeforeMethod
    public void setUp() {
        driver = new FirefoxDriver();
        driver.get(LoginPage.URL);
        loginPage = new LoginPage(driver);
    }

    // 1. a
    @Test
    public void testLoginWithValidCredentials() {
        // arrange
        loginPage.setUsername("branko.arsic");
        loginPage.setPassword("pmf#imi");

        // act
        HomePage homePage = loginPage.submitCredentials();

        // assert
        assertNotNull(homePage);
        assertEquals(homePage.getUrl(), HomePage.URL);
    }

    // 1. b
    @Test
    public void testLoginWithInvalidCredentials() {
        // arrange
        loginPage.setUsername("branko.arsic");
        loginPage.setPassword("pmf$imi");

        // act
        String errorMessage = loginPage.submitCredentialsAndGetErrorMessage();
        String errorMessageTextColor = loginPage.getTextColorOfErrorMessage();
        String errorMessageAttribute = loginPage.getErrorMessageAttribute("style");

        // assert
        assertNotNull(errorMessage);
        assertNotNull(errorMessageTextColor);
        assertNotNull(errorMessageAttribute);

        // ne koristimo assertTrue jer zelimo da se u slucaju greske prikaze pogresna
        // vrednost kako bismo dalje istrazili problem
        assertEquals(errorMessage, "Lozinka nije ispravna");
        assertEquals(errorMessageTextColor, "rgb(255, 0, 0)");

        // drugi nacin za proveru boje
        assertEquals(errorMessageAttribute, "color: red;");

        // opcino: mozemo koristiti i soft assert kako bi izbegli maskiranje gresaka
    }

    @AfterMethod
    public void tearDown() {
        driver.quit();
    }
}