package pmf.imi.hotel;

import java.util.Date;
import java.util.concurrent.TimeUnit;

public class DatumUtil {
    private Date datumOd;
    private Date datumDo;

    public DatumUtil(Date datumOd, Date datumDo) {
        this.datumOd = datumOd;
        this.datumDo = datumDo;
    }

    public int brojNocenja(){
        long diffInMillies = Math.abs(datumDo.getTime() - datumOd.getTime());
        return (int) TimeUnit.DAYS.convert(diffInMillies, TimeUnit.MILLISECONDS);
    }

    public boolean validanDatumOd(){
        Date najranije = new Date(2024, 2, 1);
        if (datumOd.before(najranije))
            return false;
        Date najkasnije = new Date(2024, 12, 31);
        if (datumOd.after(najkasnije))
            return false;

        return true;
    }
}
