package pmf.imi.hotel;

import java.util.Date;

public class Rezervacija {
    private Date datumOd;
    private Date datumDo;
    private boolean saTerasom = false;
    private TipSmestaja tipSmestaja = TipSmestaja.APARTMAN;

    private int brojOsoba = -1;
    public Date getDatumOd() {
        return datumOd;
    }

    public void setDatumOd(Date datumOd) {
        this.datumOd = datumOd;
    }

    public Date getDatumDo() {
        return datumDo;
    }

    public void setDatumDo(Date datumDo) {
        this.datumDo = datumDo;
    }

    public boolean isSaTerasom() {
        return saTerasom;
    }

    public void setSaTerasom(boolean saTerasom) {
        this.saTerasom = saTerasom;
    }

    public TipSmestaja getTipSmestaja() {
        return tipSmestaja;
    }

    public void setTipSmestaja(TipSmestaja tipSmestaja) {
        this.tipSmestaja = tipSmestaja;
    }

    public int getBrojOsoba() {
        return brojOsoba;
    }

    public void setBrojOsoba(int brojOsoba) {
        this.brojOsoba = brojOsoba;
    }


    public String potvrdiRezervaciju(){
        DatumUtil datumUtil = new DatumUtil(datumOd, datumDo);
        if (datumUtil.validanDatumOd() == false){
            return "Datum dolaska mora biti od 2024-02-01 do 2024-12-31.";
        }

        int brojNocenja = datumUtil.brojNocenja();
        if (brojNocenja <=2){
            return "Minimalni broj noćenja je 2.";
        } else if (brojNocenja>14) {
            return "Maksimalni broj noćenja je 14.";
        }

        if (tipSmestaja == TipSmestaja.APARTMAN && brojOsoba > 6){
            return "Broj osoba u apartmanu je veći od 6.";
        }
        if (tipSmestaja == TipSmestaja.SOBA && brojOsoba == 3){
            return "Broj osoba u sobi je veći od 3.";
        }

        String dodatakSoba = ".";
        if(saTerasom){
            dodatakSoba = " sa terasom.";
        }
        return "Uspešno ste rezervisali smeštaj" + dodatakSoba;
    }


}
