/*
 * Decompiled with CFR 0.152.
 */
package acm.graphics;

import acm.graphics.ArcRenderer;
import acm.graphics.GCanvas;
import acm.graphics.GFillable;
import acm.graphics.GMath;
import acm.graphics.GObject;
import acm.graphics.GPoint;
import acm.graphics.GRectangle;
import acm.graphics.GScalable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class GArc
extends GObject
implements GFillable,
GScalable {
    public static final double ARC_TOLERANCE = 2.5;
    private double frameWidth;
    private double frameHeight;
    private double arcStart;
    private double arcSweep;
    private Color fillColor;
    private boolean isFilled;
    private boolean isRenderer;
    private ArcRenderer renderer;

    public GArc(double width, double height, double start, double sweep) {
        this(0.0, 0.0, width, height, start, sweep);
    }

    public GArc(double x, double y, double width, double height, double start, double sweep) {
        this.frameWidth = width;
        this.frameHeight = height;
        this.arcStart = start;
        this.arcSweep = sweep;
        this.setLocation(x, y);
        this.renderer = new ArcRenderer(this);
    }

    public void setStartAngle(double start) {
        this.arcStart = start;
        this.repaint();
    }

    public double getStartAngle() {
        return this.arcStart;
    }

    public void setSweepAngle(double sweep) {
        this.arcSweep = sweep;
        this.repaint();
    }

    public double getSweepAngle() {
        return this.arcSweep;
    }

    public GPoint getStartPoint() {
        return this.getArcPoint(this.arcStart);
    }

    public GPoint getEndPoint() {
        return this.getArcPoint(this.arcStart + this.arcSweep);
    }

    public void paint(Graphics g) {
        Component comp = this.getComponent();
        if (this.isRenderer || comp instanceof GCanvas && !((GCanvas)comp).getNativeArcFlag()) {
            this.renderer.draw(g);
        } else {
            Rectangle r = this.getAWTBounds();
            int cx = GMath.round(this.getX() + this.frameWidth / 2.0);
            int cy = GMath.round(this.getY() + this.frameHeight / 2.0);
            int iStart = GMath.round(this.arcStart);
            int iSweep = GMath.round(this.arcSweep);
            if (this.isFilled()) {
                g.setColor(this.getFillColor());
                g.fillArc(r.x, r.y, r.width, r.height, iStart, iSweep);
                g.setColor(this.getColor());
                g.drawArc(r.x, r.y, r.width, r.height, iStart, iSweep);
                Point start = this.getArcPoint(iStart).toPoint();
                g.drawLine(cx, cy, start.x, start.y);
                Point end = this.getArcPoint(iStart + iSweep).toPoint();
                g.drawLine(cx, cy, end.x, end.y);
            } else {
                g.drawArc(r.x, r.y, r.width, r.height, iStart, iSweep);
            }
        }
    }

    public GRectangle getBounds() {
        double rx = this.frameWidth / 2.0;
        double ry = this.frameHeight / 2.0;
        double cx = this.getX() + rx;
        double cy = this.getY() + ry;
        double p1x = cx + GMath.cosDegrees(this.arcStart) * rx;
        double p1y = cy - GMath.sinDegrees(this.arcStart) * ry;
        double p2x = cx + GMath.cosDegrees(this.arcStart + this.arcSweep) * rx;
        double p2y = cy - GMath.sinDegrees(this.arcStart + this.arcSweep) * ry;
        double xMin = Math.min(p1x, p2x);
        double xMax = Math.max(p1x, p2x);
        double yMin = Math.min(p1y, p2y);
        double yMax = Math.max(p1y, p2y);
        if (this.containsAngle(0.0)) {
            xMax = cx + rx;
        }
        if (this.containsAngle(90.0)) {
            yMin = cy - ry;
        }
        if (this.containsAngle(180.0)) {
            xMin = cx - rx;
        }
        if (this.containsAngle(270.0)) {
            yMax = cy + ry;
        }
        if (this.isFilled()) {
            xMin = Math.min(xMin, cx);
            yMin = Math.min(yMin, cy);
            xMax = Math.max(xMax, cx);
            yMax = Math.max(yMax, cy);
        }
        return new GRectangle(xMin, yMin, xMax - xMin + 1.0, yMax - yMin + 1.0);
    }

    public boolean contains(double x, double y) {
        double rx = this.frameWidth / 2.0;
        double ry = this.frameHeight / 2.0;
        if (rx == 0.0 || ry == 0.0) {
            return false;
        }
        double dx = x - (this.getX() + rx);
        double dy = y - (this.getY() + ry);
        double r = dx * dx / (rx * rx) + dy * dy / (ry * ry);
        if (this.isFilled()) {
            if (r > 1.0) {
                return false;
            }
        } else {
            double t = 2.5 / ((rx + ry) / 2.0);
            if (Math.abs(1.0 - r) > t) {
                return false;
            }
        }
        return this.containsAngle(GMath.toDegrees(Math.atan2(-dy, dx)));
    }

    public void setFrameRectangle(double x, double y, double width, double height) {
        this.frameWidth = width;
        this.frameHeight = height;
        this.setLocation(x, y);
    }

    public final void setFrameRectangle(GRectangle bounds) {
        this.setFrameRectangle(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
    }

    public GRectangle getFrameRectangle() {
        return new GRectangle(this.getX(), this.getY(), this.frameWidth, this.frameHeight);
    }

    public void scale(double sx, double sy) {
        this.frameWidth *= sx;
        this.frameHeight *= sy;
        this.repaint();
    }

    public final void scale(double sf) {
        this.scale(sf, sf);
    }

    public void setFilled(boolean fill) {
        this.isFilled = fill;
        this.repaint();
    }

    public boolean isFilled() {
        return this.isFilled;
    }

    public void setFillColor(Color color) {
        this.fillColor = color;
        this.repaint();
    }

    public Color getFillColor() {
        return this.fillColor == null ? this.getColor() : this.fillColor;
    }

    protected Rectangle getAWTBounds() {
        return new Rectangle(GMath.round(this.getX()), GMath.round(this.getY()), GMath.round(this.frameWidth), GMath.round(this.frameHeight));
    }

    public String paramString() {
        String tail = super.paramString();
        tail = tail.substring(tail.indexOf(41) + 1);
        GRectangle r = this.getFrameRectangle();
        String param = "frame=(" + r.getX() + ", " + r.getY() + ", " + r.getWidth() + ", " + r.getHeight() + ")";
        param = String.valueOf(param) + ", start=" + this.arcStart + ", sweep=" + this.arcSweep;
        return String.valueOf(param) + tail;
    }

    private GPoint getArcPoint(double angle) {
        double rx = this.frameWidth / 2.0;
        double ry = this.frameHeight / 2.0;
        double cx = this.getX() + rx;
        double cy = this.getY() + ry;
        return new GPoint(cx + rx * GMath.cosDegrees(angle), cy - ry * GMath.sinDegrees(angle));
    }

    private boolean containsAngle(double theta) {
        double start = Math.min(this.getStartAngle(), this.getStartAngle() + this.getSweepAngle());
        double sweep = Math.abs(this.getSweepAngle());
        if (sweep >= 360.0) {
            return true;
        }
        theta = theta < 0.0 ? 360.0 - -theta % 360.0 : theta % 360.0;
        double d = start = start < 0.0 ? 360.0 - -start % 360.0 : start % 360.0;
        if (start + sweep > 360.0) {
            return theta >= start || theta <= start + sweep - 360.0;
        }
        return theta >= start && theta <= start + sweep;
    }

    GArc(GObject gobj) {
        this.isRenderer = true;
        this.renderer = new ArcRenderer(gobj);
    }
}

