/*
 * Decompiled with CFR 0.152.
 */
package acm.gui;

import acm.io.IODialog;
import acm.util.ErrorException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.JTextField;

public class DoubleField
extends JTextField {
    private static final int MINIMUM_WIDTH = 60;
    private static final int MINIMUM_HEIGHT = 22;
    private static final int PIXEL_MARGIN = 2;
    private boolean exceptionOnError;
    private double minValue;
    private double maxValue;
    private String formatString;
    private DecimalFormat formatter;
    private NumberFormat parser = NumberFormat.getNumberInstance(Locale.US);
    private IODialog dialog;

    public DoubleField() {
        this("", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public DoubleField(double value) {
        this("" + value, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public DoubleField(double low, double high) {
        this("", low, high);
    }

    public DoubleField(double value, double low, double high) {
        this("" + value, low, high);
    }

    private DoubleField(String str, double low, double high) {
        this.setBackground(Color.WHITE);
        this.setHorizontalAlignment(4);
        this.minValue = low;
        this.maxValue = high;
        this.setText(str);
        this.exceptionOnError = false;
    }

    public double getValue() {
        double value;
        block9: {
            String text = this.getText().trim();
            if (text.length() == 0) {
                if (this.minValue <= 0.0 && this.maxValue >= 0.0) {
                    return 0.0;
                }
                return this.minValue;
            }
            String msg = null;
            value = 0.0;
            try {
                value = this.parser.parse(text).doubleValue();
                if (value >= this.minValue && value <= this.maxValue) break block9;
                msg = "Value is outside the specified range";
            }
            catch (ParseException ex) {
                msg = "Illegal numeric format";
            }
            if (this.exceptionOnError) {
                throw new ErrorException(msg);
            }
            String prompt = "Enter a number";
            if (this.minValue != Double.NEGATIVE_INFINITY) {
                prompt = this.maxValue != Double.POSITIVE_INFINITY ? String.valueOf(prompt) + " between " + this.minValue + " and " + this.maxValue : String.valueOf(prompt) + " greater than " + this.minValue;
            } else if (this.maxValue != Double.POSITIVE_INFINITY) {
                prompt = String.valueOf(prompt) + " less than " + this.maxValue;
            }
            if (this.dialog == null) {
                this.dialog = new IODialog(this);
            }
            value = this.dialog.readDouble(prompt, this.minValue, this.maxValue);
        }
        this.setValue(value);
        return value;
    }

    public void setValue(double d) {
        this.setText(this.formatter == null ? this.defaultFormat(d) : this.formatter.format(d));
    }

    public String getFormat() {
        return this.formatString;
    }

    public void setFormat(String format) {
        String contents = this.getText().trim();
        double value = 0.0;
        if (contents.length() != 0) {
            try {
                value = this.parser.parse(contents).doubleValue();
            }
            catch (ParseException ex) {
                throw new ErrorException(ex);
            }
        }
        this.formatString = format;
        if (format == null) {
            this.formatter = null;
            this.parser = NumberFormat.getNumberInstance(Locale.US);
        } else {
            this.formatter = format.length() == 0 ? new DecimalFormat() : new DecimalFormat(format);
            this.parser = this.formatter;
        }
        if (contents.length() != 0) {
            this.setValue(value);
        }
    }

    public void setExceptionOnError(boolean flag) {
        this.exceptionOnError = flag;
    }

    public boolean getExceptionOnError() {
        return this.exceptionOnError;
    }

    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        return new Dimension(Math.max(60, size.width), Math.max(22, size.height));
    }

    private String defaultFormat(double d) {
        String str = "" + d;
        int availableSpace = this.getSize().width - 4;
        FontMetrics fm = this.getFontMetrics(this.getFont());
        if (fm.stringWidth(str) <= availableSpace) {
            return str;
        }
        int eIndex = str.indexOf("E");
        String suffix = "";
        if (eIndex != -1) {
            suffix = str.substring(eIndex);
            str = str.substring(0, eIndex);
            try {
                d = this.parser.parse(str).doubleValue();
            }
            catch (ParseException ex) {
                throw new ErrorException(ex);
            }
        }
        NumberFormat standard = NumberFormat.getNumberInstance(Locale.US);
        standard.setGroupingUsed(false);
        String head = str.substring(0, str.indexOf(46) + 1);
        int fractionSpace = availableSpace - fm.stringWidth(String.valueOf(head) + suffix);
        if (fractionSpace > 0) {
            int fractionDigits = fractionSpace / fm.stringWidth("0");
            standard.setMaximumFractionDigits(fractionDigits);
            return String.valueOf(standard.format(d)) + suffix;
        }
        str = "";
        while (fm.stringWidth(String.valueOf(str) + "#") <= availableSpace) {
            str = String.valueOf(str) + "#";
        }
        return str;
    }
}

