/*
 * Decompiled with CFR 0.152.
 */
package acmx.export;

import acm.util.ErrorException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDK11MethodPatches {
    private static String[] substitutionList = new String[]{"java/lang/String:contains:(Ljava/lang/CharSequence;)Z -> String_contains:(Ljava/lang/String;Ljava/lang/String;)Z", "java/lang/Boolean:valueOf:(Z)Ljava/lang/Boolean; -> Boolean_valueOf:(Z)Ljava/lang/Boolean;", "java/lang/Byte:valueOf:(B)Ljava/lang/Byte; -> Byte:(B)Ljava/lang/Byte;", "java/lang/Character:valueOf:(C)Ljava/lang/Character; -> Character_valueOf:(C)Ljava/lang/Character;", "java/lang/Double:valueOf:(D)Ljava/lang/Double; -> Double_valueOf:(D)Ljava/lang/Double;", "java/lang/Double:parseDouble:(Ljava/lang/String;)D -> Double_parseDouble:(Ljava/lang/String;)D", "java/lang/Float:valueOf:(F)Ljava/lang/Float; -> Float_valueOf:(F)Ljava/lang/Float;", "java/lang/Integer:valueOf:(I)Ljava/lang/Integer; -> Integer_valueOf:(I)Ljava/lang/Integer;", "java/lang/Long:valueOf:(L)Ljava/lang/Long; -> Long_valueOf:(L)Ljava/lang/Longr;", "java/lang/Short:valueOf:(S)Ljava/lang/Short; -> Short_valueOf:(S)Ljava/lang/Short;"};
    private static Map<String, String> substitutionTable;

    private JDK11MethodPatches() {
    }

    public static Map<String, String> getSubstitutionTable() {
        if (substitutionTable == null) {
            substitutionTable = new HashMap<String, String>();
            int i = 0;
            while (i < substitutionList.length) {
                String transform = substitutionList[i];
                int arrow = transform.indexOf(" -> ");
                if (arrow == -1) {
                    throw new ErrorException("Illegal substitution list entry");
                }
                String oldPrototype = transform.substring(0, arrow);
                String newPrototype = "acmx/export/JDK11MethodPatches:" + transform.substring(arrow + 4);
                substitutionTable.put(oldPrototype, newPrototype);
                ++i;
            }
        }
        return substitutionTable;
    }

    public static boolean String_contains(String str, String pattern) {
        return str.indexOf(pattern) != -1;
    }

    public static Boolean Boolean_valueOf(boolean value) {
        return new Boolean(value);
    }

    public static Byte Byte_valueOf(byte value) {
        return new Byte(value);
    }

    public static Character Character_valueOf(char value) {
        return new Character(value);
    }

    public static Double Double_valueOf(double value) {
        return new Double(value);
    }

    public static double Double_parseDouble(String str) {
        return Double.valueOf(str);
    }

    public static Float Float_getValue(float value) {
        return new Float(value);
    }

    public static Integer Integer_valueOf(int value) {
        return new Integer(value);
    }

    public static Long Long_valueOf(long value) {
        return new Long(value);
    }

    public static Short Short_valueOf(short value) {
        return new Short(value);
    }
}

